/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.model;

public class GenomicRegion
implements Comparable<GenomicRegion> {
    private String organism;
    private String chr;
    private Integer start;
    private Integer end;
    private Integer extendedRegionSize = new Integer(0);
    private Integer extendedStart;
    private Integer extendedEnd;
    private Boolean minusStrand;
    private Integer tag = null;

    public void setOrganism(String organism) {
        this.organism = organism;
    }

    public String getOrganism() {
        return this.organism;
    }

    public String getChr() {
        return this.chr;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public Integer getExtendedStart() {
        return this.extendedStart;
    }

    public void setExtendedStart(Integer extendedStart) {
        this.extendedStart = extendedStart;
    }

    public Integer getExtendedEnd() {
        return this.extendedEnd;
    }

    public void setExtendedEnd(Integer extendedEnd) {
        this.extendedEnd = extendedEnd;
    }

    public int getExtendedRegionSize() {
        return this.extendedRegionSize;
    }

    public void setExtendedRegionSize(int extendedRegionSize) {
        this.extendedRegionSize = extendedRegionSize;
    }

    public void setTag(Integer tag) {
        this.tag = tag;
    }

    public Integer getTag() {
        return this.tag;
    }

    public void setMinusStrand(Boolean minusStrand) {
        this.minusStrand = minusStrand;
    }

    public void setMinusStrand(boolean minusStrand) {
        this.minusStrand = minusStrand;
    }

    public Boolean getMinusStrand() {
        return this.minusStrand;
    }

    public String getOriginalRegion() {
        return this.chr + ":" + this.start + ".." + this.end;
    }

    public String getExtendedRegion() {
        return this.chr + ":" + this.extendedStart + ".." + this.extendedEnd;
    }

    public String getFullRegionInfo() {
        if (this.extendedRegionSize == 0) {
            return this.chr + ":" + this.start + ".." + this.end + "|" + this.extendedRegionSize + "|" + this.organism;
        }
        return this.chr + ":" + this.extendedStart + ".." + this.extendedEnd + "|" + this.chr + ":" + this.start + ".." + this.end + "|" + this.extendedRegionSize + "|" + this.organism;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenomicRegion) {
            GenomicRegion gr = (GenomicRegion)obj;
            if (gr.getOrganism() == null || gr.getTag() == null) {
                return this.chr.equals(gr.getChr()) && this.start.equals(gr.getStart()) && this.end.equals(gr.getEnd());
            }
            return this.chr.equals(gr.getChr()) && this.start.equals(gr.getStart()) && this.end.equals(gr.getEnd()) && this.organism.equals(gr.getOrganism()) && this.extendedRegionSize.equals(gr.getExtendedRegionSize()) && this.tag == gr.getTag();
        }
        return false;
    }

    public String toString() {
        return this.getOriginalRegion() + (this.getOriginalRegion().equals(this.getExtendedRegion()) ? "" : " +/- " + this.extendedRegionSize);
    }

    public int hashCode() {
        if (this.organism == null) {
            return this.chr.hashCode() + this.start.hashCode() + this.end.hashCode();
        }
        return this.chr.hashCode() + this.start.hashCode() + this.end.hashCode() + this.organism.hashCode() + this.extendedRegionSize.hashCode();
    }

    @Override
    public int compareTo(GenomicRegion gr) {
        int bEFORE = -1;
        boolean eQUAL = false;
        boolean aFTER = true;
        if (this == gr) {
            return 0;
        }
        if (this.getChr().compareTo(gr.getChr()) < 0) {
            return -1;
        }
        if (this.getChr().compareTo(gr.getChr()) > 0) {
            return 1;
        }
        if (this.extendedRegionSize == 0) {
            if (this.getStart() < gr.getStart()) {
                return -1;
            }
            if (this.getStart() > gr.getStart()) {
                return 1;
            }
            if (this.getEnd() < gr.getEnd()) {
                return -1;
            }
            if (this.getEnd() > gr.getEnd()) {
                return 1;
            }
            return 0;
        }
        if (this.getExtendedStart() < gr.getExtendedStart()) {
            return -1;
        }
        if (this.getExtendedStart() > gr.getExtendedStart()) {
            return 1;
        }
        if (this.getExtendedEnd() < gr.getExtendedEnd()) {
            return -1;
        }
        if (this.getExtendedEnd() > gr.getExtendedEnd()) {
            return 1;
        }
        return 0;
    }

    public boolean isOverlapped(GenomicRegion gr) {
        return false;
    }
}

