/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.struts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebResults;
import org.intermine.api.results.WebTable;
import org.intermine.api.util.NameUtil;
import org.intermine.bio.web.export.GenomicRegionSequenceExporter;
import org.intermine.bio.web.logic.GenomicRegionSearchService;
import org.intermine.bio.web.logic.GenomicRegionSearchUtil;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.bio.web.model.GenomicRegionSearchConstraint;
import org.intermine.bio.web.struts.BEDExportForm;
import org.intermine.bio.web.struts.GFF3ExportForm;
import org.intermine.bio.web.struts.SequenceExportForm;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.export.RowFormatter;
import org.intermine.web.logic.export.http.HttpExportUtil;
import org.intermine.web.logic.export.http.TableExporterFactory;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.export.rowformatters.CSVRowFormatter;
import org.intermine.web.logic.export.rowformatters.TabRowFormatter;
import org.intermine.web.logic.export.string.StringTableExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.TableExportForm;

public class GenomicRegionSearchAjaxAction
extends Action {
    private String spanUUIDString;
    private GenomicRegionSearchService grsService;
    private Map<String, Map<GenomicRegion, List<List<String>>>> spanOverlapFullResultMap;
    private Map<String, Map<GenomicRegion, Map<String, Integer>>> spanOverlapFullStatMap;
    private Map<GenomicRegionSearchConstraint, String> spanConstraintMap;
    private HttpSession session;
    private WebConfig webConfig;
    private Profile profile;
    private InterMineAPI api;

    private void init(HttpServletRequest request, HttpServletResponse response) {
        this.session = request.getSession();
        this.spanUUIDString = request.getParameter("spanUUIDString");
        this.grsService = GenomicRegionSearchUtil.getGenomicRegionSearchService((HttpServletRequest)request);
        this.spanOverlapFullResultMap = (Map)this.session.getAttribute("spanOverlapFullResultMap");
        this.spanOverlapFullStatMap = (Map)this.session.getAttribute("spanOverlapFullStatMap");
        this.spanConstraintMap = (HashMap)this.session.getAttribute("spanConstraintMap");
        this.webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        this.profile = SessionMethods.getProfile((HttpSession)this.session);
        this.api = SessionMethods.getInterMineAPI((HttpSession)this.session);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.init(request, response);
        response.setContentType("text/plain");
        if (request.getParameter("getProgress") != null) {
            this.getProgress(response);
        }
        if (request.getParameter("getData") != null && request.getParameter("fromIdx") != null && request.getParameter("toIdx") != null) {
            int fromIdx = Integer.parseInt(request.getParameter("fromIdx"));
            int toIdx = Integer.parseInt(request.getParameter("toIdx"));
            this.getData(fromIdx, toIdx, response);
        }
        if (request.getParameter("getFeatures") != null && request.getParameter("grString") != null) {
            String grString = request.getParameter("grString");
            this.getFeatures(grString, response);
        }
        if (request.getParameter("isEmptyFeature") != null) {
            PrintWriter out = response.getWriter();
            out.println(this.grsService.isEmptyFeature((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString)));
        }
        if (request.getParameter("generateCreateListHtml") != null) {
            PrintWriter out = response.getWriter();
            out.println(this.grsService.generateCreateListHtml((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString)));
        }
        if (request.getParameter("isSearch") == null || request.getParameter("spansToSearch") != null) {
            // empty if block
        }
        if (request.getParameter("exportFeatures") != null) {
            String criteria = request.getParameter("criteria");
            String facet = request.getParameter("facet");
            String format = request.getParameter("format");
            this.exportFeatures(criteria, facet, format, request, response);
        }
        if (request.getParameter("getFeatureCount") != null) {
            String criteria = request.getParameter("criteria");
            String facet = request.getParameter("facet");
            this.getFeatureCountOfGenomicRegion(criteria, facet, response);
        }
        if (request.getParameter("createList") != null) {
            String criteria = request.getParameter("criteria");
            String facet = request.getParameter("facet");
            this.createListByFeatureType(criteria, facet, response);
        }
        if (request.getParameter("getDropDownList") != null) {
            this.getRegionsForDropDownList(response);
        }
        if (request.getParameter("getGivenRegionsResults") != null) {
            String regions = request.getParameter("regions");
            LinkedHashSet<String> regionSet = new LinkedHashSet<String>();
            regionSet.add(regions);
            this.getDataByRegions(regionSet, response);
        }
        if (request.getParameter("groupRegions") != null) {
            String interval = request.getParameter("interval");
            this.getGroupRegions(interval, response);
        }
        return null;
    }

    private void getProgress(HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.println(((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString)).size());
        out.flush();
        out.close();
    }

    private void getData(int fromIdx, int toIdx, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        List genomicRegionList = null;
        for (Map.Entry e : this.spanConstraintMap.entrySet()) {
            if (!((String)e.getValue()).equals(this.spanUUIDString)) continue;
            genomicRegionList = ((GenomicRegionSearchConstraint)e.getKey()).getGenomicRegionList();
        }
        String htmlStr = this.grsService.convertResultMapToHTML((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString), (Map)this.spanOverlapFullStatMap.get(this.spanUUIDString), genomicRegionList, fromIdx, toIdx, this.session);
        out.println(htmlStr);
        out.flush();
        out.close();
    }

    private void getDataByRegions(Set<String> regionSet, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        List grList = GenomicRegionSearchUtil.generateGenomicRegions(regionSet);
        String htmlStr = this.grsService.convertResultMapToHTML((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString), (Map)this.spanOverlapFullStatMap.get(this.spanUUIDString), grList, 0, grList.size() - 1, this.session);
        out.println(htmlStr);
        out.flush();
        out.close();
    }

    private void getFeatures(String grInfo, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        String featureIds = this.grsService.getGenomicRegionOverlapFeaturesAsString(grInfo, (Map)this.spanOverlapFullResultMap.get(this.spanUUIDString));
        out.println(featureIds);
        out.flush();
        out.close();
    }

    private void exportFeatures(String criteria, String facet, String format, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map featureMap = (Map)this.spanOverlapFullResultMap.get(this.spanUUIDString);
        if ("all".equals(criteria) && ("tab".equals(format) || "csv".equals(format))) {
            StringTableExporter stringExporter;
            PrintWriter writer = HttpExportUtil.getPrintWriterForClient((HttpServletRequest)request, (OutputStream)response.getOutputStream());
            if ("csv".equals(format)) {
                stringExporter = new StringTableExporter(writer, (RowFormatter)new CSVRowFormatter());
                ResponseUtil.setCSVHeader((HttpServletResponse)response, (String)"results-table.csv");
            } else {
                stringExporter = new StringTableExporter(writer, (RowFormatter)new TabRowFormatter());
                ResponseUtil.setTabHeader((HttpServletResponse)response, (String)"results-table.tsv");
            }
            ArrayList<ArrayList<String>> exportResults = new ArrayList<ArrayList<String>>();
            String[] hearderArr = new String[]{"DB identifier", "Symbol", "Chr", "Start", "End", "User input"};
            ArrayList<String> headerList = new ArrayList<String>(Arrays.asList(hearderArr));
            int extendedSize = ((GenomicRegion)featureMap.keySet().iterator().next()).getExtendedRegionSize();
            if (extendedSize > 0) {
                headerList.add("Extended input");
            }
            if (((GenomicRegion)featureMap.keySet().iterator().next()).getTag() != null) {
                headerList.add("User identifier");
            }
            exportResults.add(headerList);
            for (Map.Entry e : featureMap.entrySet()) {
                if (e.getValue() == null) continue;
                for (List l : (List)e.getValue()) {
                    String pid = (String)l.get(1);
                    String symbol = (String)l.get(2);
                    String chr = (String)l.get(4);
                    String start = (String)l.get(5);
                    String end = (String)l.get(6);
                    String userInput = ((GenomicRegion)e.getKey()).getOriginalRegion();
                    String[] rowArr = new String[]{pid, symbol, chr, start, end, userInput};
                    ArrayList<String> row = new ArrayList<String>(Arrays.asList(rowArr));
                    if (extendedSize > 0) {
                        String extendedInput = ((GenomicRegion)e.getKey()).getExtendedRegion();
                        row.add(extendedInput);
                    }
                    if (((GenomicRegion)e.getKey()).getTag() != null) {
                        String tag = ((GenomicRegion)e.getKey()).getTag().toString();
                        row.add(tag);
                    }
                    exportResults.add(row);
                }
            }
            stringExporter.export(exportResults);
        } else if ("chrSeg".equals(format)) {
            String exportFileName;
            ArrayList grList;
            if ("all".equals(criteria)) {
                grList = new ArrayList(((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString)).keySet());
                exportFileName = "genomic_region_all.fasta";
            } else {
                grList = GenomicRegionSearchUtil.generateGenomicRegions(Arrays.asList(criteria));
                exportFileName = "genomic_region.fasta";
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + exportFileName + "\"");
            ResponseUtil.setCustomContentType((HttpServletResponse)response, (String)"text/x-fasta");
            ServletOutputStream out = response.getOutputStream();
            GenomicRegionSequenceExporter grse = new GenomicRegionSequenceExporter(this.api.getObjectStore(), (OutputStream)out);
            grse.export(grList);
        } else {
            TableExporterFactory factory;
            TableHttpExporter exporter;
            boolean doGzip = false;
            Set<Integer> featureIdSet = new LinkedHashSet();
            if ("all".equals(criteria)) {
                for (List l : featureMap.values()) {
                    if (l == null) continue;
                    for (List r : l) {
                        featureIdSet.add(Integer.valueOf((String)r.get(0)));
                    }
                }
            } else {
                featureIdSet = this.grsService.getGenomicRegionOverlapFeaturesAsSet(criteria, featureMap);
            }
            LinkedHashSet<String> exportFeaturesViews = null;
            List<String> exportFeaturesSortOrder = null;
            String exportFeaturesViewsStr = SessionMethods.getWebProperties((ServletContext)this.session.getServletContext()).getProperty("genomicRegionSearch.query." + facet + ".views");
            String exportFeaturesSortOrderStr = SessionMethods.getWebProperties((ServletContext)this.session.getServletContext()).getProperty("genomicRegionSearch.query." + facet + ".sortOrder");
            if (exportFeaturesViewsStr != null && !exportFeaturesViewsStr.isEmpty()) {
                try {
                    exportFeaturesViews = new LinkedHashSet<String>(Arrays.asList(StringUtil.split((String)exportFeaturesViewsStr, (String)",")));
                    exportFeaturesSortOrder = Arrays.asList(StringUtil.split((String)exportFeaturesSortOrderStr, (String)" "));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            PathQuery q = this.grsService.getExportFeaturesQuery(featureIdSet, facet, exportFeaturesViews, exportFeaturesSortOrder);
            String organism = new String();
            for (Map.Entry e : this.spanConstraintMap.entrySet()) {
                if (!((String)e.getValue()).equals(this.spanUUIDString)) continue;
                organism = ((GenomicRegionSearchConstraint)e.getKey()).getOrgName();
            }
            HashSet<String> organisms = new HashSet<String>();
            organisms.add(organism);
            Set taxIds = this.grsService.getTaxonIds(organisms);
            WebResultsExecutor executor = this.api.getWebResultsExecutor(this.profile);
            PagedTable pt = new PagedTable((WebTable)executor.execute(q));
            if (pt.getWebTable() instanceof WebResults) {
                ((WebResults)pt.getWebTable()).goFaster();
            }
            if ((exporter = (factory = new TableExporterFactory(this.webConfig)).getExporter(format)) == null) {
                throw new RuntimeException("unknown export format: " + format);
            }
            TableExportForm exportForm = new TableExportForm();
            exportForm.setIncludeHeaders(true);
            if ("gff3".equals(format)) {
                exportForm = new GFF3ExportForm();
                exportForm.setDoGzip(doGzip);
                ((GFF3ExportForm)exportForm).setOrganisms(taxIds);
            }
            if ("sequence".equals(format)) {
                exportForm = new SequenceExportForm();
                exportForm.setDoGzip(doGzip);
            }
            if ("bed".equals(format)) {
                String ucscCompatibleCheck = "yes";
                exportForm = new BEDExportForm();
                exportForm.setDoGzip(doGzip);
                ((BEDExportForm)exportForm).setOrgansimString(organism);
                ((BEDExportForm)exportForm).setUcscCompatibleCheck(ucscCompatibleCheck);
            }
            exporter.export(pt, request, response, exportForm, null, null);
        }
    }

    private void getFeatureCountOfGenomicRegion(String criteria, String facet, HttpServletResponse response) throws Exception {
        Set featureIdSet = new LinkedHashSet();
        Map featureMap = (Map)this.spanOverlapFullResultMap.get(this.spanUUIDString);
        featureIdSet = "all".equals(criteria) ? this.grsService.getAllGenomicRegionOverlapFeaturesByType(featureMap, facet) : this.grsService.getGenomicRegionOverlapFeaturesByType(criteria, featureMap, facet);
        PrintWriter out = response.getWriter();
        out.println(featureIdSet.size());
        out.flush();
        out.close();
    }

    private void createListByFeatureType(String criteria, String facet, HttpServletResponse response) throws Exception {
        String newCriteria = criteria;
        Set featureIdSet = new LinkedHashSet();
        Map featureMap = (Map)this.spanOverlapFullResultMap.get(this.spanUUIDString);
        if ("all".equals(criteria)) {
            featureIdSet = this.grsService.getAllGenomicRegionOverlapFeaturesByType(featureMap, facet);
            newCriteria = criteria + "_regions";
        } else {
            featureIdSet = this.grsService.getGenomicRegionOverlapFeaturesByType(criteria, featureMap, facet);
            newCriteria = criteria.split("\\|")[0].replaceAll(":", "_").replaceAll("\\.\\.", "_");
        }
        String bagName = newCriteria + "_" + facet + "_list";
        bagName = NameUtil.generateNewName(this.profile.getSavedBags().keySet(), (String)bagName);
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)this.session);
        try {
            InterMineBag bag = this.profile.createBag(bagName, facet, "", (Map)im.getClassKeys());
            bag.addIdsToBag(featureIdSet, facet);
            this.profile.saveBag(bag.getName(), bag);
        }
        catch (ObjectStoreException e) {
            e.printStackTrace();
        }
        PrintWriter out = response.getWriter();
        out.println(bagName);
        out.flush();
        out.close();
    }

    private void getRegionsForDropDownList(HttpServletResponse response) throws IOException {
        ArrayList grList = new ArrayList(((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString)).keySet());
        Collections.sort(grList);
        ArrayList<String> grToStringList = new ArrayList<String>();
        for (GenomicRegion gr : grList) {
            grToStringList.add(gr.getFullRegionInfo());
        }
        String jointed = StringUtil.join(grToStringList, (String)",");
        PrintWriter out = response.getWriter();
        out.println(jointed);
        out.flush();
        out.close();
    }

    private void getGroupRegions(String interval, HttpServletResponse response) throws Exception {
        List grList = GenomicRegionSearchUtil.groupGenomicRegionByInterval((String)interval, ((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString)).keySet());
        String htmlStr = this.grsService.convertResultMapToHTML((Map)this.spanOverlapFullResultMap.get(this.spanUUIDString), (Map)this.spanOverlapFullStatMap.get(this.spanUUIDString), grList, 0, grList.size() - 1, this.session);
        PrintWriter out = response.getWriter();
        out.println(htmlStr);
        out.flush();
        out.close();
    }
}

