/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.struts;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.bio.web.logic.GenomicRegionSearchService;
import org.intermine.bio.web.logic.GenomicRegionSearchUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenomicRegionSearchOptionsController
extends TilesAction {
    private static final String GALAXY_SERVER_CONNECTION_ERROR = "Failed to fetch genomic region data from Galaxy server";
    private static final String GALAXY_SERVER_CONNECTION_SUCCESSFUL = "Fetched genomic region data from Galaxy server";

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        session.setAttribute("tabName", (Object)"genomicRegionSearch");
        GenomicRegionSearchService grsService = GenomicRegionSearchUtil.getGenomicRegionSearchService((HttpServletRequest)request);
        String webData = grsService.setupWebData();
        String optionsJavascript = grsService.getOptionsJavascript();
        request.setAttribute("webData", (Object)webData);
        request.setAttribute("optionsJavascript", (Object)optionsJavascript);
        String galaxyDataUrl = request.getParameter("DATA_URL");
        String genomeBuild = request.getParameter("GENOME");
        if (galaxyDataUrl != null) {
            galaxyDataUrl = galaxyDataUrl.trim();
            genomeBuild = genomeBuild.trim();
            String galaxyInput = GenomicRegionSearchOptionsController.fetchGalaxyData((String)galaxyDataUrl);
            if (galaxyInput.equals("Failed to fetch genomic region data from Galaxy server")) {
                String errMsg = "Failed to fetch genomic region data from Galaxy server: " + galaxyDataUrl;
                request.setAttribute("galaxyFetchDataError", (Object)errMsg);
            } else {
                galaxyInput = galaxyInput.replaceAll("( )+", "\t");
                galaxyInput = StringEscapeUtils.escapeJavaScript((String)galaxyInput);
                request.setAttribute("galaxyIntervalData", (Object)galaxyInput);
                request.setAttribute("galaxyIntervalDataGenomeBuild", (Object)genomeBuild);
                String successMsg = "Fetched genomic region data from Galaxy server: " + galaxyDataUrl + "<br>Genome Build: " + genomeBuild + "<br>Format: bed";
                request.setAttribute("galaxyFetchDataSuccess", (Object)successMsg);
            }
        }
        return null;
    }

    private static String fetchGalaxyData(String galaxyDataUrl) {
        String galaxyInput;
        try {
            URL url = new URL(galaxyDataUrl);
            URLConnection conn = url.openConnection();
            galaxyInput = new String(IOUtils.toCharArray((InputStream)conn.getInputStream())).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Failed to fetch genomic region data from Galaxy server";
        }
        return galaxyInput;
    }
}

