/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.StringUtil;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.Exporter;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebServiceRequestParser;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.query.AbstractQueryService;
import org.intermine.webservice.server.query.result.PathQueryBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BioQueryService
extends AbstractQueryService {
    private static final String QUERY_PARAM = "query";
    private static final String VIEW_PARAM = "view";
    private PrintWriter pw;
    private OutputStream os;

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public BioQueryService(InterMineAPI im) {
        super(im);
    }

    protected String getDefaultFileName() {
        return "results" + StringUtil.uniqueString() + this.getSuffix();
    }

    protected abstract String getSuffix();

    protected abstract String getContentType();

    protected Output getDefaultOutput(PrintWriter out, OutputStream outputstream, String sep) {
        this.os = outputstream;
        this.pw = out;
        this.output = new StreamedOutput(out, (Formatter)new PlainFormatter(), sep);
        if (this.isUncompressed()) {
            ResponseUtil.setCustomTypeHeader((HttpServletResponse)this.response, (String)this.getDefaultFileName(), (String)this.getContentType());
        }
        return this.output;
    }

    public Format getDefaultFormat() {
        return Format.UNKNOWN;
    }

    protected PathQuery getQuery() {
        String queryString = this.getRequiredParameter("query");
        PathQueryBuilder builder = this.getQueryBuilder(queryString);
        PathQuery pq = builder.getQuery();
        ArrayList<String> newView = new ArrayList<String>();
        HashSet<ClassDescriptor> seenTypes = new HashSet<ClassDescriptor>();
        for (String viewPath : pq.getView()) {
            Path p;
            try {
                p = new Path(pq.getModel(), viewPath);
            }
            catch (PathException e) {
                throw new BadRequestException("Query is invalid", (Throwable)e);
            }
            ClassDescriptor cd = p.getLastClassDescriptor();
            if (!seenTypes.contains(cd)) {
                newView.add(viewPath);
            }
            seenTypes.add(cd);
        }
        return pq;
    }

    protected abstract Exporter getExporter(PathQuery var1);

    protected void checkPathQuery(PathQuery pq) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
        PathQuery pathQuery = this.getQuery();
        this.checkPathQuery(pathQuery);
        List views = BioQueryService.getPathQueryViews((String[])this.request.getParameterValues("view"));
        if (views != null) {
            try {
                pathQuery.addViews((Collection)views);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Bad value for view parameter", (Throwable)e);
            }
            ArrayList al = new ArrayList();
            al.clear();
            al.addAll(new LinkedHashSet(pathQuery.getView()));
            pathQuery.clearView();
            pathQuery.addViews(al);
        }
        Exporter exporter = this.getExporter(pathQuery);
        ExportResultsIterator iter = null;
        try {
            iter = executor.execute(pathQuery, 0, WebServiceRequestParser.DEFAULT_LIMIT.intValue());
            iter.goFaster();
            exporter.export((Iterator)iter);
        }
        finally {
            if (iter != null) {
                iter.releaseGoFaster();
            }
        }
    }

    protected static List<String> getPathQueryViews(String[] views) {
        if (views == null || views.length < 1) {
            return null;
        }
        ArrayList<String> viewList = new ArrayList<String>();
        for (String view : views) {
            viewList.add(view.trim());
        }
        return viewList;
    }

    protected List<Path> getQueryPaths(PathQuery pq) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String view : pq.getView()) {
            try {
                paths.add(pq.makePath(view));
            }
            catch (PathException e) {
                e.printStackTrace();
            }
        }
        return paths;
    }
}

