/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.webservice.ExternalLinksService;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Organism;
import org.intermine.objectstore.ObjectStore;
import org.intermine.web.context.InterMineContext;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ServiceException;

public class ExternalLinksService
extends JSONService {
    protected static final Logger LOG = Logger.getLogger(ExternalLinksService.class);
    static final String ATTR_MARKER_RE = "<<attributeValue>>";
    static final String JSON_KEY = "links";

    public ExternalLinksService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        Object reportObject = null;
        InterMineObject imo = null;
        InterMineAPI im = InterMineContext.getInterMineAPI();
        ObjectStore os = im.getObjectStore();
        Model model = im.getModel();
        Integer interMineID = Integer.valueOf(this.request.getParameter("id"));
        imo = im.getObjectStore().getObjectById(interMineID);
        if (imo == null) {
            this.addResultEntry(JSON_KEY, (Object)"", false);
            throw new ServiceException("no object with ID " + interMineID, 400);
        }
        Set classDescriptors = model.getClassDescriptorsForClass(imo.getClass());
        StringBuffer sb = new StringBuffer();
        for (ClassDescriptor cd : classDescriptors) {
            if (sb.length() <= 0) {
                sb.append("(");
            } else {
                sb.append("|");
            }
            sb.append(TypeUtil.unqualifiedName((String)cd.getName()));
        }
        StringBuffer append = sb.append(")");
        Organism organismReference = null;
        String geneOrgKey = sb.toString();
        try {
            organismReference = (Organism)imo.getFieldValue("organism");
        }
        catch (Exception exception) {
            // empty catch block
        }
        geneOrgKey = organismReference == null || organismReference.getTaxonId() == null ? geneOrgKey + "(\\.(\\*))?" : geneOrgKey + "(\\.(" + organismReference.getTaxonId() + "|\\*))?";
        HashMap<String, ConfigMap> linkConfigs = new HashMap<String, ConfigMap>();
        Properties webProperties = (Properties)this.request.getServletContext().getAttribute("WEB_PROPERTIES");
        String regexp = "attributelink\\.([^.]+)\\." + geneOrgKey + "\\.([^.]+)(\\.list)?\\.(url|text|imageName|usePost|delimiter|enctype|dataset|useCheckbox)";
        Pattern p = Pattern.compile(regexp);
        String className = null;
        String taxId = null;
        for (Map.Entry<Object, Object> entry : webProperties.entrySet()) {
            ConfigMap config;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher matcher = p.matcher(key);
            if (!matcher.matches()) continue;
            String dbName = matcher.group(1);
            className = matcher.group(2);
            taxId = matcher.group(4);
            String attrName = matcher.group(5);
            String imType = matcher.group(6);
            String propType = matcher.group(7);
            if (imo != null && imType != null) continue;
            if (linkConfigs.containsKey(dbName)) {
                config = (ConfigMap)linkConfigs.get(dbName);
            } else {
                config = new ConfigMap(this, null);
                config.put((Object)"attributeName", (Object)attrName);
                config.put((Object)"linkId", (Object)dbName);
                linkConfigs.put(dbName, config);
            }
            Object attrValue = null;
            Object taxIds = null;
            if (config.containsKey((Object)"attributeValue")) {
                attrValue = config.get((Object)"attributeValue");
            } else {
                try {
                    if (imo != null) {
                        attrValue = imo.getFieldValue(attrName);
                    }
                    if (attrValue != null) {
                        config.put((Object)"attributeValue", attrValue);
                        config.put((Object)"valid", (Object)Boolean.TRUE);
                    }
                }
                catch (IllegalAccessException e) {
                    config.put((Object)"attributeValue", (Object)e);
                    config.put((Object)"valid", (Object)Boolean.FALSE);
                    LOG.error((Object)("configuration problem in ExternalLinksService: couldn't get a value for field " + attrName + " in class " + className));
                }
            }
            if ("url".equals(propType)) {
                if (attrValue == null) continue;
                String url = value.contains(ATTR_MARKER_RE) ? value.replaceAll(ATTR_MARKER_RE, String.valueOf(attrValue)) : value + attrValue;
                config.put((Object)"url", (Object)url);
                continue;
            }
            if ("imageName".equals(propType)) {
                config.put((Object)"imageName", (Object)value);
                continue;
            }
            if ("usePost".equals(propType)) {
                config.put((Object)"usePost", (Object)value);
                continue;
            }
            if ("delimiter".equals(propType)) {
                config.put((Object)"delimiter", (Object)value);
                continue;
            }
            if ("enctype".equals(propType)) {
                config.put((Object)"enctype", (Object)value);
                continue;
            }
            if ("dataset".equals(propType)) {
                config.put((Object)"dataset", (Object)value);
                continue;
            }
            if ("useCheckbox".equals(propType)) {
                config.put((Object)"useCheckbox", (Object)value);
                continue;
            }
            if (!"text".equals(propType)) continue;
            config.put((Object)"title", (Object)value.replaceAll("[^A-Za-z0-9 ]", "").replaceFirst("attributeValue", ""));
            String text = value.replaceAll(ATTR_MARKER_RE, String.valueOf(attrValue));
            config.put((Object)"text", (Object)text);
        }
        this.addResultEntry(JSON_KEY, linkConfigs, false);
    }
}

