/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.export.SequenceExporter;
import org.intermine.bio.webservice.BioQueryService;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.Exporter;
import org.intermine.webservice.server.exceptions.BadRequestException;

/*
 * Exception performing whole class analysis ignored.
 */
public class FastaQueryService
extends BioQueryService {
    private static final String EXT = "extension";
    private static final String TRL = "translate";
    private static final String TOO_MANY_COLUMNS = "Queries for this webservice may only have one output column";
    private static final int COLUMN = 0;

    public FastaQueryService(InterMineAPI im) {
        super(im);
    }

    protected String getSuffix() {
        return ".fa";
    }

    protected String getContentType() {
        return "text/x-fasta";
    }

    protected Exporter getExporter(PathQuery pq) {
        int extension = FastaQueryService.parseExtension((String)this.getOptionalParameter("extension", "0"));
        String translate = this.getOptionalParameter("translate", "N");
        ObjectStore objStore = this.im.getObjectStore();
        return new SequenceExporter(objStore, this.getOutputStream(), 0, (Map)this.im.getClassKeys(), extension, translate, this.getQueryPaths(pq));
    }

    protected PathQuery getQuery() {
        PathQuery pq = super.getQuery();
        return pq;
    }

    protected static int parseExtension(String extension) throws BadRequestException {
        float number;
        if (StringUtils.isBlank((String)extension)) {
            return 0;
        }
        String ext = extension.toLowerCase().trim();
        if (!ext.matches("^((\\d+)|(\\d+(\\.\\d+)?(k|m)))(bp?)?$")) {
            throw new BadRequestException("Illegal extension format: " + ext);
        }
        String justTheNumber = ext.replaceAll("[kmbp]", "");
        int scale = ext.contains("k") ? 1000 : (ext.contains("m") ? 1000000 : 1);
        try {
            number = Float.parseFloat(justTheNumber) * (float)scale;
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Illegal number: " + justTheNumber, (Throwable)e);
        }
        if (number < 0.0f) {
            throw new BadRequestException("Negative extensions are not allowed.");
        }
        if ((double)number != Math.ceil(number)) {
            throw new BadRequestException("The extension must be a whole number of base pairs. I got: " + number + "bp");
        }
        return Math.round(number);
    }

    protected void checkPathQuery(PathQuery pq) throws Exception {
        Path path = pq.makePath((String)pq.getView().get(0));
        ClassDescriptor klazz = path.getLastClassDescriptor();
        ClassDescriptor sf = this.im.getModel().getClassDescriptorByName("SequenceFeature");
        ClassDescriptor protein = this.im.getModel().getClassDescriptorByName("Protein");
        if (sf == klazz || protein == klazz || klazz.getAllSuperDescriptors().contains(sf) || klazz.getAllSuperDescriptors().contains(protein)) {
            return;
        }
        throw new BadRequestException("Unsuitable type for export: " + klazz);
    }
}

