/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.bio.web.export.BEDExporter;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.bio.webservice.AbstractRegionExportService;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.Exporter;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class GenomicRegionBedService
extends AbstractRegionExportService {
    protected static final String SUFFIX = ".fasta";
    private static final String UCSC_COMPATIBLE = "ucscCompatible";
    private static final String TRACK_DESCRIPTION = "trackDescription";

    public GenomicRegionBedService(InterMineAPI im) {
        super(im);
    }

    protected Exporter getExporter(PathQuery pq) {
        boolean isUcsc = !"no".equalsIgnoreCase(this.getOptionalParameter(UCSC_COMPATIBLE, "yes"));
        String sourceName = this.webProperties.getProperty("project.title");
        String sourceReleaseVersion = this.webProperties.getProperty("project.releaseVersion");
        String descr = sourceName + " " + sourceReleaseVersion + " Custom Track";
        String trackDescription = this.getOptionalParameter(TRACK_DESCRIPTION, descr);
        String organisms = StringUtils.join((Collection)SequenceFeatureExportUtil.getOrganisms((PathQuery)pq, (InterMineAPI)this.im, (Profile)this.getPermission().getProfile()), (String)",");
        List<Integer> indexes = Arrays.asList(new Integer(0));
        return new BEDExporter(this.getPrintWriter(), indexes, sourceName, organisms, isUcsc, trackDescription);
    }

    protected String getContentType() {
        return "text/x-ucsc-bed";
    }

    protected String getSuffix() {
        return ".bed";
    }

    protected void checkPathQuery(PathQuery pq) throws Exception {
        try {
            SequenceFeatureExportUtil.isValidSequenceFeatureQuery((PathQuery)pq);
        }
        catch (SequenceFeatureExportUtil.InvalidQueryException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

