/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.export.SequenceExporter;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.bio.webservice.AbstractRegionExportService;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.Exporter;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class GenomicRegionFastaService
extends AbstractRegionExportService {
    protected static final String SUFFIX = ".fasta";

    public GenomicRegionFastaService(InterMineAPI im) {
        super(im);
    }

    protected String getContentType() {
        return "text/x-fasta";
    }

    protected Exporter getExporter(PathQuery pq) {
        return new SequenceExporter(this.im.getObjectStore(), this.getOutputStream(), 0, (Map)this.im.getClassKeys(), 0, "n");
    }

    protected String getSuffix() {
        return SUFFIX;
    }

    protected void checkPathQuery(PathQuery pq) throws Exception {
        try {
            SequenceFeatureExportUtil.isValidFastaQuery((PathQuery)pq);
        }
        catch (SequenceFeatureExportUtil.InvalidQueryException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

