/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.util.MailUtils;

public class Emailer {
    private static final String PREFIX = "mail.regarding.";
    private final Properties properties;

    public Emailer(Properties properties) {
        this.properties = properties;
    }

    public void email(String to, String messageKey) throws MessagingException {
        String subject = this.properties.getProperty(PREFIX + messageKey + ".subject");
        String body = this.properties.getProperty(PREFIX + messageKey + ".body");
        MailUtils.email((String)to, (String)subject, (String)body, (Properties)this.properties);
    }

    public void email(String to, String messageKey, Object ... vars) throws MessagingException {
        String subject = this.properties.getProperty(PREFIX + messageKey + ".subject");
        String bodyFmt = this.properties.getProperty(PREFIX + messageKey + ".body");
        if (StringUtils.isBlank((String)bodyFmt)) {
            throw new MessagingException("No email template configured for " + messageKey);
        }
        String body = String.format(bodyFmt, vars);
        MailUtils.email((String)to, (String)subject, (String)body, (Properties)this.properties);
    }

    public void welcome(String to) throws MessagingException {
        MailUtils.welcome((String)to, (Properties)this.properties);
    }

    public void sendFareWell(String address, String xml) throws MessagingException {
        String appName = this.properties.getProperty("project.title");
        String subjectFmt = this.properties.getProperty("mail.regarding.farewell.subject");
        String subject = String.format(subjectFmt, appName);
        String bodyFmt = this.properties.getProperty("mail.regarding.farewell.body");
        String body = String.format(bodyFmt, appName, address, xml);
        MailUtils.email((String)address, (String)subject, (String)body, (Properties)this.properties);
    }

    public String subscribeToList(String address) throws MessagingException {
        String mailingList = this.properties.getProperty("mail.mailing-list");
        if (!StringUtils.isBlank((String)mailingList)) {
            MailUtils.subscribe((String)address, (Properties)this.properties);
            return mailingList;
        }
        return null;
    }

    public void informUserOfNewSharedBag(String to, Profile owner, InterMineBag bag) throws MessagingException, ObjectStoreException, UnsupportedEncodingException {
        String appName = this.properties.getProperty("project.title");
        String subjectFmt = this.properties.getProperty("mail.regarding.newly.shared.subject");
        String subject = String.format(subjectFmt, appName, owner.getUsername());
        String bodyFmt = this.properties.getProperty("mail.regarding.newly.shared.body");
        String base = this.properties.getProperty("webapp.baseurl");
        String path = this.properties.getProperty("webapp.path");
        String body = String.format(bodyFmt, appName, owner.getUsername(), bag.getType(), bag.getSize(), bag.getName(), base, path, URLEncoder.encode(bag.getName(), "UTF-8"));
        MailUtils.email((String)to, (String)subject, (String)body, (Properties)this.properties);
    }
}

