/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.profile.Profile;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.web.uri.InterMineLUIConverter;
import org.intermine.web.util.URLGenerator;

public class PermanentURIHelper {
    private HttpServletRequest request;
    private static final Logger LOGGER = Logger.getLogger(PermanentURIHelper.class);

    public PermanentURIHelper(HttpServletRequest request) {
        this.request = request;
    }

    public String getPermanentURI(InterMineLUI lui) {
        String permanentURI = null;
        String baseURI = this.getPermanentBaseURI();
        if (!baseURI.endsWith("/")) {
            baseURI = baseURI + "/";
        }
        permanentURI = baseURI + lui.toString();
        return permanentURI;
    }

    public String getPermanentBaseURI() {
        Properties webProperties = InterMineContext.getWebProperties();
        String baseURI = webProperties.getProperty("identifier.uri.base");
        if (baseURI == null || StringUtils.isEmpty((String)baseURI)) {
            baseURI = new URLGenerator(this.request).getPermanentBaseURL();
        }
        return baseURI;
    }

    public String getPermanentURL(Integer interMineId, Profile profile) {
        InterMineLUIConverter converter = new InterMineLUIConverter(profile);
        InterMineLUI interMineLUI = null;
        interMineLUI = converter.getInterMineLUI(interMineId);
        return this.getPermanentURL(interMineLUI);
    }

    public String getPermanentURL(InterMineLUI lui) {
        if (lui != null) {
            String baseURL = new URLGenerator(this.request).getPermanentBaseURL();
            if (!baseURL.endsWith("/")) {
                baseURL = baseURL + "/";
            }
            String permanentURL = baseURL + lui.toString();
            return permanentURL;
        }
        return null;
    }
}

