/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.export;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.intermine.api.results.ResultElement;
import org.intermine.pathquery.Path;
import org.intermine.web.logic.export.CustomPrintWriter;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.Exporter;
import org.intermine.web.logic.export.ResultElementConverter;
import org.intermine.web.logic.export.RowFormatter;

public class ExporterImpl
implements Exporter {
    private PrintWriter out;
    private RowFormatter rowFormatter;
    private int writtenResultsCount = 0;
    private final List<String> headers;

    public ExporterImpl(OutputStream out, RowFormatter rowFormatter) {
        this.headers = null;
        this.out = new PrintWriter(out);
        this.rowFormatter = rowFormatter;
    }

    public ExporterImpl(OutputStream out, RowFormatter rowFormatter, String separator, List<String> headers) {
        this.headers = headers;
        this.out = separator.equals("\r\n") ? new CustomPrintWriter(out, "\r\n") : new PrintWriter(out);
        this.rowFormatter = rowFormatter;
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        try {
            if (this.headers != null) {
                this.out.println(this.rowFormatter.format(new ArrayList(this.headers)));
            }
            this.out.flush();
            ResultElementConverter converter = new ResultElementConverter();
            while (resultIt.hasNext()) {
                List<ResultElement> result = resultIt.next();
                this.out.println(this.rowFormatter.format(converter.convert(result, unionPathCollection, newPathCollection)));
                ++this.writtenResultsCount;
                if (this.writtenResultsCount % 10000 != 0 || !this.out.checkError()) continue;
                throw new ExportException("Output closed");
            }
            this.out.flush();
        }
        catch (RuntimeException e) {
            throw new ExportException("Export failed.", (Exception)e);
        }
    }

    public void export(Iterator<? extends List<ResultElement>> resultIt) {
        this.export(resultIt, new HashSet(), new HashSet());
    }

    public int getWrittenResultsCount() {
        return this.writtenResultsCount;
    }

    public boolean canExport(List<Class<?>> clazzes) {
        return true;
    }
}

