/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.export.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.intermine.api.results.Column;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.pathquery.Path;
import org.intermine.web.logic.RequestUtil;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.ExportHelper;
import org.intermine.web.logic.export.Exporter;
import org.intermine.web.logic.export.http.HttpExporterBase;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.TableExportForm;

public abstract class StandardHttpExporter
extends HttpExporterBase
implements TableHttpExporter {
    protected static final Logger LOG = Logger.getLogger(StandardHttpExporter.class);

    public boolean canExport(PagedTable pt) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(PagedTable pt, HttpServletRequest request, HttpServletResponse response, TableExportForm form, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        Exporter exporter;
        block11: {
            boolean doGzip = form != null && form.getDoGzip();
            Object out = null;
            try {
                out = response.getOutputStream();
                if (doGzip) {
                    out = new GZIPOutputStream((OutputStream)out);
                }
            }
            catch (IOException e) {
                throw new ExportException("Export failed.", (Exception)e);
            }
            this.setResponseHeader(response, doGzip);
            String separator = RequestUtil.isWindowsClient((HttpServletRequest)request) ? "\r\n" : "\n";
            List headers = null;
            if (form != null && form.getIncludeHeaders()) {
                headers = this.getHeaders(pt, SessionMethods.getWebConfig((HttpServletRequest)request), newPathCollection);
            }
            exporter = this.getExporter((OutputStream)out, separator, headers);
            ExportResultsIterator iter = null;
            try {
                iter = this.getResultRows(pt, request);
                iter.goFaster();
                exporter.export((Iterator)iter, unionPathCollection, newPathCollection);
                if (!(out instanceof GZIPOutputStream)) break block11;
                try {
                    ((GZIPOutputStream)out).finish();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (iter != null) {
                    iter.releaseGoFaster();
                }
            }
        }
        if (exporter.getWrittenResultsCount() == 0) {
            throw new ExportException("Nothing was found for export.");
        }
    }

    private List<String> getHeaders(PagedTable pt, WebConfig webConfig, Collection<Path> pathCollection) {
        ArrayList<String> headers = new ArrayList<String>();
        List ptCols = pt.getColumns();
        ArrayList<Path> colPathList = new ArrayList<Path>();
        for (Column col : ptCols) {
            colPathList.add(col.getPath());
        }
        if (pathCollection != null && colPathList.containsAll(pathCollection)) {
            for (Path p : pathCollection) {
                headers.add(WebUtil.formatPath((Path)p, (WebConfig)webConfig));
            }
        } else {
            for (Column col : pt.getColumns()) {
                headers.add(WebUtil.formatPath((Path)col.getPath(), (WebConfig)webConfig));
            }
        }
        return headers;
    }

    public List<Path> getInitialExportPaths(PagedTable pt) {
        return ExportHelper.getColumnPaths((PagedTable)pt);
    }

    protected abstract Exporter getExporter(OutputStream var1, String var2, List<String> var3);

    protected abstract void setResponseHeader(HttpServletResponse var1, boolean var2);
}

