/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.export.http;

import java.util.HashMap;
import java.util.Map;
import org.intermine.web.logic.config.TableExportConfig;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.http.CSVHttpExporter;
import org.intermine.web.logic.export.http.TabHttpExporter;
import org.intermine.web.logic.export.http.TableHttpExporter;

public class TableExporterFactory {
    private static final String TAB = "tab";
    private static final String CSV = "csv";
    private static Map<String, String> exporters = new HashMap();
    private Map<String, TableExportConfig> configs = new HashMap();

    public TableExporterFactory(WebConfig webConfig) {
        try {
            this.register(TAB, TabHttpExporter.class.getCanonicalName());
            this.register(CSV, CSVHttpExporter.class.getCanonicalName());
            this.processConfig(webConfig);
        }
        catch (Exception e) {
            throw new ExportException("Export failed.", e);
        }
    }

    private void processConfig(WebConfig webConfig) throws Exception {
        this.configs = webConfig.getTableExportConfigs();
        for (String key : this.configs.keySet()) {
            TableExportConfig config = (TableExportConfig)this.configs.get(key);
            this.register(key, config.getClassName());
        }
    }

    public TableHttpExporter getExporter(String id) throws Exception {
        String className = (String)exporters.get(id);
        if (className != null) {
            return (TableHttpExporter)Class.forName(className).newInstance();
        }
        return null;
    }

    public TableExportConfig getConfig(String id) {
        return (TableExportConfig)this.configs.get(id);
    }

    public void register(String id, String className) throws Exception {
        TableHttpExporter exp = this.getExporter(id);
        if (exp == null) {
            exporters.put(id, className);
        }
    }
}

