/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.profile;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.bag.BagQueryResult;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.bag.BagQueryUpgrade;
import org.intermine.api.profile.BagState;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;

public class UpgradeBagList
implements Runnable {
    private static final Logger LOG = Logger.getLogger(UpgradeBagList.class);
    private Profile profile;
    private BagQueryRunner bagQueryRunner;

    public UpgradeBagList(Profile profile, BagQueryRunner bagQueryRunner) {
        this.profile = profile;
        this.bagQueryRunner = bagQueryRunner;
    }

    @Override
    public void run() {
        Map savedBags = this.profile.getSavedBags();
        for (InterMineBag bag : savedBags.values()) {
            if (!this.isBagNeedUpgrade(bag)) continue;
            String bagName = bag.getName();
            BagQueryUpgrade bagQueryUpgrade = new BagQueryUpgrade(this.bagQueryRunner, bag);
            BagQueryResult result = bagQueryUpgrade.getBagQueryResult();
            try {
                if (result.getUnresolvedIdentifiers().isEmpty() && (result.getIssues().isEmpty() || this.onlyOtherIssuesAlreadyContained(result))) {
                    Map matches = result.getMatches();
                    bag.upgradeOsb(matches.keySet(), false);
                    continue;
                }
                bag.setState(BagState.TO_UPGRADE);
            }
            catch (ObjectStoreException ose) {
                LOG.warn((Object)("Could not upgrade the list " + bagName), (Throwable)ose);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBagNeedUpgrade(InterMineBag bag) {
        InterMineBag interMineBag = bag;
        synchronized (interMineBag) {
            if (bag.getState().equals(BagState.NOT_CURRENT.toString())) {
                try {
                    bag.setState(BagState.UPGRADING);
                }
                catch (ObjectStoreException ose) {
                    LOG.error((Object)("Problem to update the status to UPGRADING for list " + bag.getName()), (Throwable)ose);
                }
                return true;
            }
            return false;
        }
    }

    private boolean onlyOtherIssuesAlreadyContained(BagQueryResult result) {
        if (result.getIssues().get("DUPLICATE") == null && result.getIssues().get("TYPE_CONVERTED") == null && result.getIssues().get("WILDCARD") == null) {
            Map otherMatchMap = (Map)result.getIssues().get("OTHER");
            Set matchesIds = result.getMatches().keySet();
            if (otherMatchMap != null) {
                LinkedHashMap lowQualityMatches = new LinkedHashMap();
                for (Map inputToObjectsMap : otherMatchMap.values()) {
                    LinkedHashMap<String, List> inputToObjectsMapUpdated = new LinkedHashMap<String, List>();
                    for (String key : inputToObjectsMap.keySet()) {
                        List listObjects = (List)inputToObjectsMap.get(key);
                        ArrayList listObjectsUpdated = new ArrayList();
                        for (Object obj : listObjects) {
                            InterMineObject intermineObj = (InterMineObject)obj;
                            if (!matchesIds.isEmpty() && matchesIds.contains(intermineObj.getId())) continue;
                            listObjectsUpdated.add(obj);
                        }
                        if (listObjectsUpdated.isEmpty()) continue;
                        inputToObjectsMapUpdated.put(key, listObjects);
                    }
                    if (inputToObjectsMapUpdated.isEmpty()) continue;
                    lowQualityMatches.putAll(inputToObjectsMapUpdated);
                }
                if (lowQualityMatches.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }
}

