/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.util.Properties;
import org.intermine.api.InterMineAPI;
import org.intermine.model.InterMineObject;
import org.intermine.util.CacheMap;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.results.ReportObject;

public class ReportObjectFactory
extends CacheMap<InterMineObject, ReportObject> {
    private final InterMineAPI im;
    private final WebConfig webConfig;
    private final Properties webProperties;

    public ReportObjectFactory(InterMineAPI im, WebConfig webConfig, Properties webProperties) {
        this.im = im;
        this.webConfig = webConfig;
        this.webProperties = webProperties;
    }

    public boolean containsKey(Object key) {
        return true;
    }

    public synchronized ReportObject get(Object object) {
        InterMineObject imObj = (InterMineObject)object;
        ReportObject reportObject = (ReportObject)super.get((Object)imObj);
        if (reportObject == null) {
            try {
                reportObject = new ReportObject(imObj, this.webConfig, this.im, this.webProperties);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to make a reportObject", e);
            }
            super.put((Object)imObj, (Object)reportObject);
        }
        return reportObject;
    }

    public ReportObject put(InterMineObject key, ReportObject value) {
        throw new UnsupportedOperationException("Put called on ReportObjectFactory");
    }
}

