/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.session;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.apache.struts.util.MessageResources;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.SavedQuery;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebResults;
import org.intermine.api.results.WebTable;
import org.intermine.api.search.SearchRepository;
import org.intermine.api.util.NameUtil;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.ResultsInfo;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplateQuery;
import org.intermine.web.autocompletion.AutoCompleter;
import org.intermine.web.logic.aspects.Aspect;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.query.PageTableQueryMonitor;
import org.intermine.web.logic.query.QueryMonitor;
import org.intermine.web.logic.query.QueryMonitorTimeout;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.results.ReportObjectFactory;
import org.intermine.web.logic.results.WebState;
import org.intermine.web.logic.session.QueryCountQueryMonitor;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.registry.model.Instance;
import org.intermine.web.struts.LoadQueryAction;
import org.intermine.web.struts.TemplateAction;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SessionMethods {
    protected static final Logger LOG = Logger.getLogger(SessionMethods.class);
    private static int topQueryId = 0;
    private static int index = 0;

    private SessionMethods() {
    }

    public static boolean runQuery(HttpSession session, MessageResources resources, String qid, Action action, CompletionCallBack completionCallBack) throws Exception {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ObjectStore os = im.getObjectStore();
        ObjectStoreInterMineImpl ios = os instanceof ObjectStoreInterMineImpl ? (ObjectStoreInterMineImpl)os : null;
        Map queries = SessionMethods.getRunningQueries((HttpSession)session);
        QueryMonitor monitor = (QueryMonitor)queries.get(qid);
        1 runnable = new /* Unavailable Anonymous Inner Class!! */;
        Thread thread = null;
        thread = new Thread((Runnable)runnable);
        thread.start();
        while (thread.isAlive()) {
            boolean cancelled;
            Thread.sleep(1000L);
            if (monitor == null || !(cancelled = monitor.shouldCancelQuery()) || ios == null) continue;
            LOG.debug((Object)("Cancelling request " + runnable));
            ios.cancelRequest((Object)runnable);
            monitor.queryCancelled();
            return false;
        }
        if (runnable.isError()) {
            if (monitor != null) {
                monitor.queryCancelledWithError();
            }
            return false;
        }
        if (completionCallBack != null) {
            completionCallBack.complete();
        }
        if (monitor != null) {
            monitor.queryCompleted();
        }
        return true;
    }

    public static void loadQuery(PathQuery query, HttpSession session, HttpServletResponse response) {
        if (query instanceof TemplateQuery) {
            TemplateQuery template = (TemplateQuery)query;
            SessionMethods.setQuery((HttpSession)session, (PathQuery)template.clone());
        } else {
            SessionMethods.setQuery((HttpSession)session, (PathQuery)query.clone());
        }
        try {
            String rootPath = query.getRootClass();
            session.setAttribute("path", (Object)rootPath);
        }
        catch (PathException e) {
            throw new RuntimeException("Attempt to load invalid query: " + query, e);
        }
        session.removeAttribute("prefix");
    }

    public static List<String> getEditingView(HttpSession session) {
        PathQuery query = SessionMethods.getQuery((HttpSession)session);
        if (query == null) {
            throw new IllegalStateException("No query on session");
        }
        return query.getView();
    }

    public static SavedQuery saveQuery(HttpSession session, String queryName, PathQuery query, Date created) {
        Profile profile = (Profile)session.getAttribute("PROFILE");
        PathQuery cloned = query.clone();
        SavedQuery sq = new SavedQuery(queryName, created != null ? created : new Date(), cloned);
        profile.saveQuery(sq.getName(), sq);
        WebResultsExecutor wre = SessionMethods.getInterMineAPI((HttpSession)session).getWebResultsExecutor(profile);
        ResultsInfo info = wre.getQueryInfo(query);
        if (info != null) {
            wre.setQueryInfo(cloned, info);
        }
        return sq;
    }

    public static void saveQuery(HttpSession session, String queryName, PathQuery query) {
        SessionMethods.saveQuery((HttpSession)session, (String)queryName, (PathQuery)query, null);
    }

    public static void saveQueryToHistory(HttpSession session, String queryName, PathQuery query) {
        Profile profile = (Profile)session.getAttribute("PROFILE");
        PathQuery cloned = query.clone();
        SavedQuery sq = new SavedQuery(queryName, new Date(), cloned);
        profile.saveHistory(sq);
        WebResultsExecutor wre = SessionMethods.getInterMineAPI((HttpSession)session).getWebResultsExecutor(profile);
        ResultsInfo info = wre.getQueryInfo(query);
        if (info != null) {
            wre.setQueryInfo(cloned, info);
        }
        session.setAttribute("infoCache", (Object)wre.getInfoCache());
    }

    public static void recordMessage(String message, HttpSession session) {
        SessionMethods.recordMessage((String)message, (String)"MESSAGES", (HttpSession)session);
    }

    public static void recordError(String error, HttpSession session) {
        SessionMethods.recordMessage((String)error, (String)"ERRORS", (HttpSession)session);
    }

    private static void recordMessage(String message, String attrib, HttpSession session) {
        Set<String> set = (Set<String>)session.getAttribute(attrib);
        if (set == null) {
            set = Collections.synchronizedSet(new LinkedHashSet());
            session.setAttribute(attrib, set);
        }
        set.add(message);
    }

    public static void logTemplateQueryUse(HttpSession session, String templateType, String templateName) {
        Logger log = Logger.getLogger(TemplateAction.class);
        Profile profile = (Profile)session.getAttribute("PROFILE");
        String username = profile.getUsername();
        if (username == null) {
            username = "anonymous";
        }
        log.info((Object)(username + "\t" + templateType + "\t" + templateName));
    }

    public static void logExampleQueryUse(HttpSession session, String exampleName) {
        Logger log = Logger.getLogger(LoadQueryAction.class);
        Profile profile = (Profile)session.getAttribute("PROFILE");
        String username = profile.getUsername();
        if (username == null) {
            username = "anonymous";
        }
        log.info((Object)(username + "\t" + exampleName));
    }

    public static ReportObjectFactory getReportObjects(HttpSession session) {
        ServletContext servletContext = session.getServletContext();
        ReportObjectFactory reportObjects = (ReportObjectFactory)servletContext.getAttribute("REPORT_OBJECT_CACHE");
        if (reportObjects == null) {
            InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
            WebConfig webConfig = SessionMethods.getWebConfig((ServletContext)servletContext);
            Properties webProperties = SessionMethods.getWebProperties((ServletContext)servletContext);
            reportObjects = new ReportObjectFactory(im, webConfig, webProperties);
            servletContext.setAttribute("REPORT_OBJECT_CACHE", (Object)reportObjects);
        }
        return reportObjects;
    }

    public static void initSession(HttpSession session) {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ProfileManager pm = im.getProfileManager();
        session.setAttribute("PROFILE", (Object)pm.createAnonymousProfile());
        session.setAttribute("RESULTS_TABLE_SIZE", (Object)25);
    }

    public static String startQueryWithTimeout(HttpServletRequest request, boolean saveQuery, PathQuery pathQuery) {
        QueryMonitorTimeout clientState = new QueryMonitorTimeout(20000);
        clientState.setPathQuery(pathQuery);
        MessageResources messages = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        return SessionMethods.startQuery((QueryMonitor)clientState, (HttpSession)request.getSession(), (MessageResources)messages, (boolean)saveQuery, (PathQuery)pathQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String startQuery(QueryMonitor monitor, HttpSession session, MessageResources messages, boolean saveQuery, PathQuery pathQuery) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            Map queries = SessionMethods.getRunningQueries((HttpSession)session);
            String qid = "" + topQueryId++;
            queries.put(qid, monitor);
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return qid;
        }
    }

    public static void logQuery(HttpSession session) throws PathException {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        PathQuery pathQuery = SessionMethods.getQuery((HttpSession)session).clone();
        im.getTrackerDelegate().trackQuery(pathQuery.getRootClass(), profile, session.getId());
        String queryName = NameUtil.findNewQueryName(profile.getHistory().keySet());
        SessionMethods.saveQueryToHistory((HttpSession)session, (String)queryName, (PathQuery)pathQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String startPagedTableCount(PageTableQueryMonitor monitor, HttpSession session, MessageResources messages) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            Map queries = SessionMethods.getRunningQueries((HttpSession)session);
            String qid = "" + topQueryId++;
            queries.put(qid, monitor);
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return qid;
        }
    }

    private static Map<String, QueryMonitor> getRunningQueries(HttpSession session) {
        HashMap queries = (HashMap)session.getAttribute("RUNNING_QUERIES");
        if (queries == null) {
            queries = new HashMap();
            session.setAttribute("RUNNING_QUERIES", queries);
        }
        return queries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String startQueryCount(QueryCountQueryMonitor monitor, HttpSession session, MessageResources messages) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            Map queries = SessionMethods.getRunningQueries((HttpSession)session);
            String qid = "" + topQueryId++;
            queries.put(qid, monitor);
            Query query = monitor.getQuery();
            InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
            ObjectStore os = im.getObjectStore();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return qid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryMonitor getRunningQueryController(String qid, HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            Map queries = SessionMethods.getRunningQueries((HttpSession)session);
            QueryMonitor controller = (QueryMonitor)queries.get(qid);
            return controller;
        }
    }

    public static PagedTable getResultsTable(HttpSession session, String identifier) {
        Map tables = (Map)session.getAttribute("TABLE_MAP");
        if (tables != null) {
            return (PagedTable)tables.get(identifier);
        }
        return null;
    }

    public static void setResultsTable(HttpSession session, String identifier, PagedTable table) {
        Map<String, PagedTable> tables = (Map<String, PagedTable>)session.getAttribute("TABLE_MAP");
        if (tables == null) {
            tables = Collections.synchronizedMap(new LRUMap(100));
            session.setAttribute("TABLE_MAP", tables);
        }
        tables.put(identifier, table);
        table.setTableid(identifier);
    }

    public static void invalidateBagTable(HttpSession session, String name) {
        Map tables = (Map)session.getAttribute("TABLE_MAP");
        if (tables != null) {
            tables.remove("bag." + name);
        }
    }

    public static String getDefaultOperator(HttpSession session) {
        String op = (String)session.getAttribute("DEFAULT_OPERATOR");
        if (op == null) {
            op = "and";
        }
        return op;
    }

    public static boolean isSuperUser(HttpSession session) {
        Boolean superUserAttribute = (Boolean)session.getAttribute("IS_SUPERUSER");
        return superUserAttribute != null && superUserAttribute.equals(Boolean.TRUE);
    }

    public static void moveToRequest(String attributeName, HttpServletRequest request) {
        HttpSession session = request.getSession();
        request.setAttribute(attributeName, session.getAttribute(attributeName));
        session.removeAttribute(attributeName);
    }

    public static PagedTable doQueryGetPagedTable(HttpServletRequest request, InterMineBag imBag) throws ObjectStoreException {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = im.getModel();
        WebConfig webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        PathQuery pathQuery = PathQueryResultHelper.makePathQueryForBag((InterMineBag)imBag, (WebConfig)webConfig, (Model)model);
        WebResultsExecutor executor = im.getWebResultsExecutor(SessionMethods.getProfile((HttpSession)session));
        WebResults webResults = executor.execute(pathQuery);
        String identifier = "bag." + imBag.getName();
        PagedTable pagedResults = new PagedTable((WebTable)webResults);
        SessionMethods.setResultsTable((HttpSession)session, (String)identifier, (PagedTable)pagedResults);
        return pagedResults;
    }

    public static PagedTable doQueryGetPagedTable(HttpServletRequest request, InterMineObject obj, String field, String referencedClassName) throws ObjectStoreException {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ObjectStore os = im.getObjectStore();
        WebConfig webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        PathQuery pathQuery = PathQueryResultHelper.makePathQueryForCollection((WebConfig)webConfig, (ObjectStore)os, (InterMineObject)obj, (String)referencedClassName, (String)field);
        SessionMethods.setQuery((HttpSession)session, (PathQuery)pathQuery);
        WebResultsExecutor executor = im.getWebResultsExecutor(SessionMethods.getProfile((HttpSession)session));
        WebResults webResults = executor.execute(pathQuery);
        String identifier = "coll" + index++;
        PagedTable pagedResults = new PagedTable((WebTable)webResults);
        SessionMethods.setResultsTable((HttpSession)session, (String)identifier, (PagedTable)pagedResults);
        return pagedResults;
    }

    public static WebConfig getWebConfig(HttpServletRequest request) {
        return SessionMethods.getWebConfig((ServletContext)request.getSession().getServletContext());
    }

    public static WebConfig getWebConfig(ServletContext context) {
        WebConfig wc = (WebConfig)context.getAttribute("WEBCONFIG");
        if (wc == null) {
            throw new RuntimeException("WebConfig not present in web session.");
        }
        return wc;
    }

    public static void setWebConfig(ServletContext context, WebConfig webConfig) {
        context.setAttribute("WEBCONFIG", (Object)webConfig);
    }

    public static WebState getWebState(HttpSession session) {
        WebState webState = (WebState)session.getAttribute("WEB_STATE");
        if (webState == null) {
            webState = new WebState();
            session.setAttribute("WEB_STATE", (Object)webState);
        }
        return webState;
    }

    public static Profile getProfile(HttpSession session) {
        return (Profile)session.getAttribute("PROFILE");
    }

    public static void setProfile(HttpSession session, Profile profile) {
        session.setAttribute("PROFILE", (Object)profile);
    }

    public static Map<String, Aspect> getAspects(ServletContext servletContext) {
        return (Map)servletContext.getAttribute("ASPECTS");
    }

    public static void setAspects(ServletContext servletContext, Map<String, Aspect> aspects) {
        servletContext.setAttribute("ASPECTS", aspects);
    }

    public static Properties getWebProperties(ServletContext servletContext) {
        return (Properties)servletContext.getAttribute("WEB_PROPERTIES");
    }

    public static Properties getWebProperties(HttpServletRequest request) {
        return SessionMethods.getWebProperties((ServletContext)request.getSession().getServletContext());
    }

    public static void setWebProperties(ServletContext servletContext, Properties props) {
        servletContext.setAttribute("WEB_PROPERTIES", (Object)props);
    }

    public static void setPropertiesOrigins(ServletContext servletContext, Map<String, List<String>> origins) {
        servletContext.setAttribute("PROPERTIES_ORIGINS", origins);
    }

    public static Map<String, List<String>> getPropertiesOrigins(HttpSession session) {
        return (Map)session.getServletContext().getAttribute("PROPERTIES_ORIGINS");
    }

    public static PathQuery getQuery(HttpSession session) {
        return (PathQuery)session.getAttribute("QUERY");
    }

    public static PathQuery getQuery(HttpServletRequest request) {
        return (PathQuery)request.getSession().getAttribute("QUERY");
    }

    public static void setQuery(HttpSession session, PathQuery query) {
        session.setAttribute("QUERY", (Object)query);
    }

    public static void removeQuery(HttpSession session) {
        session.removeAttribute("QUERY");
    }

    public static SearchRepository getGlobalSearchRepository(ServletContext context) {
        return (SearchRepository)context.getAttribute("GLOBAL_SEARCH_REPOSITORY");
    }

    public static void setGlobalSearchRepository(ServletContext context, SearchRepository repo) {
        context.setAttribute("GLOBAL_SEARCH_REPOSITORY", (Object)repo);
    }

    public static InterMineAPI getInterMineAPI(HttpSession session) {
        return SessionMethods.getInterMineAPI((ServletContext)session.getServletContext());
    }

    public static InterMineAPI getInterMineAPI(HttpServletRequest request) {
        return SessionMethods.getInterMineAPI((HttpSession)request.getSession());
    }

    public static InterMineAPI getInterMineAPI(ServletContext servletContext) {
        return (InterMineAPI)servletContext.getAttribute("INTERMINE_API");
    }

    public static void setInterMineAPI(ServletContext servletContext, InterMineAPI im) {
        servletContext.setAttribute("INTERMINE_API", (Object)im);
    }

    public static AutoCompleter getAutoCompleter(ServletContext servletContext) {
        return (AutoCompleter)servletContext.getAttribute("AUTO_COMPLETER");
    }

    public static void setAutoCompleter(ServletContext servletContext, AutoCompleter ac) {
        servletContext.setAttribute("AUTO_COMPLETER", (Object)ac);
    }

    public static Set<String> getCategories(ServletContext servletContext) {
        return (Set)servletContext.getAttribute("CATEGORIES");
    }

    public static void setCategories(ServletContext servletContext, Set<String> categories) {
        servletContext.setAttribute("CATEGORIES", categories);
    }

    public static void setErrorOnInitialiser(ServletContext servletContext, Map<String, String> errorKey) {
        servletContext.setAttribute("INITIALISER_KEY_ERROR", errorKey);
    }

    public static Map<String, String> getErrorOnInitialiser(ServletContext servletContext) {
        String key = "INITIALISER_KEY_ERROR";
        return servletContext.getAttribute(key) == null ? null : (Map)servletContext.getAttribute(key);
    }

    public static boolean isErrorOnInitialiser(ServletContext servletContext) {
        Map errorKeys = SessionMethods.getErrorOnInitialiser((ServletContext)servletContext);
        return errorKeys != null && !errorKeys.isEmpty();
    }

    public static void setOpenIdProviders(ServletContext ctx, Set<String> providers) {
        ctx.setAttribute("OPENID_PROVIDERS", providers);
    }

    public static Set<String> getOpenIdProviders(HttpSession session) {
        ServletContext ctx = session.getServletContext();
        return (Set)ctx.getAttribute("OPENID_PROVIDERS");
    }

    public static void setOAuth2Providers(ServletContext ctx, Set<String> providers) {
        ctx.setAttribute("OAUTH2_PROVIDERS", providers);
    }

    public static Set<String> getOAuth2Providers(HttpSession session) {
        ServletContext ctx = session.getServletContext();
        return (Set)ctx.getAttribute("OAUTH2_PROVIDERS");
    }

    public static void setBasicInstanceInfo(ServletContext ctx, Instance instance) {
        ctx.setAttribute("INSTANCE_INFO", (Object)instance);
    }

    public static Instance getBasicInstanceInfo(HttpSession session) {
        ServletContext ctx = session.getServletContext();
        return (Instance)ctx.getAttribute("INSTANCE_INFO");
    }

    static /* synthetic */ Map access$100(HttpSession x0) {
        return SessionMethods.getRunningQueries((HttpSession)x0);
    }
}

