/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.pathquery.PathConstraint;
import org.intermine.web.logic.widget.DataSetLdr;
import org.intermine.web.logic.widget.GraphWidgetActionType;
import org.intermine.web.logic.widget.WidgetLdr;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfigUtil;

public class GraphWidgetLoader
extends WidgetLdr
implements DataSetLdr {
    private GraphWidgetConfig config;
    private Results results;
    private int items;
    private List<List<Object>> resultTable = new LinkedList();
    private String type;

    public GraphWidgetLoader(InterMineBag bag, ObjectStore os, GraphWidgetConfig config, String filter, String ids, String type) {
        super(bag, os, filter, (WidgetConfig)config, ids);
        this.type = type;
        this.config = config;
        LinkedHashMap categorySeriesMap = new LinkedHashMap();
        if (!config.comparesActualToExpected()) {
            Query q = this.createQuery(GraphWidgetActionType.ACTUAL);
            this.results = os.execute(q);
            this.buildCategorySeriesMap(categorySeriesMap);
        } else {
            int totalInBagWithLocation = this.addActual(categorySeriesMap);
            LinkedHashMap categoryMapInDB = new LinkedHashMap();
            int totalInDBWithLocation = this.addExpected(categoryMapInDB);
            this.buildCategorySeriesMapForActualExpectedCriteria(categorySeriesMap, categoryMapInDB, totalInBagWithLocation, totalInDBWithLocation);
        }
        this.populateResultTable(categorySeriesMap);
        this.calcTotal();
    }

    private Query createQuery(GraphWidgetActionType action) {
        Query mainQuery;
        Query subQ;
        Model model = this.os.getModel();
        Query query = new Query();
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        query.setConstraint((Constraint)cs);
        query.addFrom((FromElement)this.startClass);
        this.queryClassInQuery = new HashMap();
        String key = this.startClass.getType().getSimpleName();
        this.queryClassInQuery.put(key, this.startClass);
        QueryField qfCategoryPath = null;
        QueryField qfSeriesPath = null;
        if (!GraphWidgetActionType.TOTAL.equals((Object)action)) {
            qfCategoryPath = this.createQueryFieldByPath(this.config.getCategoryPath(), query, true);
            if (!this.config.comparesActualToExpected() && this.config.hasSeries()) {
                qfSeriesPath = this.createQueryFieldByPath(this.config.getSeriesPath(), query, true);
            }
        }
        QueryField idQueryField = null;
        if (this.config.getTypeClass().equals(this.config.getStartClass())) {
            idQueryField = new QueryField(this.startClass, "id");
            if (!GraphWidgetActionType.EXPECTED.equals((Object)action)) {
                cs.addConstraint((Constraint)this.createBagConstraint(idQueryField));
            }
        } else {
            QueryClass bagTypeQueryClass;
            String bagType = this.type;
            try {
                if (this.bag != null) {
                    bagType = this.bag.getType();
                }
                bagTypeQueryClass = new QueryClass(new Class[]{Class.forName(model.getPackageName() + "." + bagType)});
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Not found the class typebag for the bag " + bagType, e);
            }
            query.addFrom((FromElement)bagTypeQueryClass);
            idQueryField = new QueryField(bagTypeQueryClass, "id");
            if (!GraphWidgetActionType.EXPECTED.equals((Object)action)) {
                cs.addConstraint((Constraint)this.createBagConstraint(idQueryField));
            }
            QueryClass qc = null;
            String bagPath = this.config.getListPath();
            String path = bagPath.split("\\.")[1];
            try {
                QueryObjectReference qor = null;
                if (bagPath.startsWith(this.config.getStartClass())) {
                    qor = new QueryObjectReference(this.startClass, path);
                    qc = bagTypeQueryClass;
                } else {
                    qor = new QueryObjectReference(bagTypeQueryClass, path);
                    qc = this.startClass;
                }
                cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qor, ConstraintOp.CONTAINS, qc));
            }
            catch (IllegalArgumentException e) {
                QueryCollectionReference qcr = null;
                if (bagPath.startsWith(this.config.getStartClass())) {
                    qcr = new QueryCollectionReference(this.startClass, path);
                    qc = bagTypeQueryClass;
                } else {
                    qcr = new QueryCollectionReference(bagTypeQueryClass, path);
                    qc = this.startClass;
                }
                cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qcr, ConstraintOp.CONTAINS, qc));
            }
        }
        for (PathConstraint pathConstraint : this.config.getPathConstraints()) {
            this.addConstraint(pathConstraint, query);
        }
        QueryFunction qfCount = new QueryFunction();
        if (!GraphWidgetActionType.TOTAL.equals((Object)action)) {
            query.setDistinct(false);
            query.addToSelect((QuerySelectable)idQueryField);
            query.addToOrderBy((QueryOrderable)idQueryField);
            query.addToGroupBy((QueryNode)idQueryField);
            subQ = query;
            mainQuery = new Query();
            mainQuery.setDistinct(false);
            mainQuery.addFrom((FromElement)subQ);
            QueryField qfSubCategoryPath = new QueryField(subQ, (QueryEvaluable)qfCategoryPath);
            mainQuery.addToSelect((QuerySelectable)qfSubCategoryPath);
            QueryField qfSubSeriesPath = null;
            if (qfSeriesPath != null) {
                qfSubSeriesPath = new QueryField(subQ, (QueryEvaluable)qfSeriesPath);
                mainQuery.addToSelect((QuerySelectable)qfSubSeriesPath);
            }
            mainQuery.addToSelect((QuerySelectable)qfCount);
            mainQuery.addToGroupBy((QueryNode)qfSubCategoryPath);
            if (qfSeriesPath != null) {
                mainQuery.addToGroupBy((QueryNode)qfSubSeriesPath);
            }
            return mainQuery;
        }
        subQ = query;
        subQ.setDistinct(true);
        subQ.addToSelect((QuerySelectable)idQueryField);
        mainQuery = new Query();
        mainQuery.setDistinct(false);
        mainQuery.addFrom((FromElement)subQ);
        mainQuery.addToSelect((QuerySelectable)qfCount);
        return mainQuery;
    }

    private BagConstraint createBagConstraint(QueryField queryField) {
        if (this.bag != null) {
            return new BagConstraint((QueryNode)queryField, ConstraintOp.IN, this.bag.getOsb());
        }
        if (this.idsList != null) {
            return new BagConstraint((QueryNode)queryField, ConstraintOp.IN, (Collection)this.idsList);
        }
        return null;
    }

    private void addConstraint(PathConstraint pc, Query query) {
        QueryClass qc = this.startClass;
        QueryField qfConstraint = null;
        ConstraintSet cs = (ConstraintSet)query.getConstraint();
        String[] pathConstraintSplitted = pc.getPath().split("\\.");
        boolean isFilterConstraint = WidgetConfigUtil.isFilterConstraint((WidgetConfig)this.config, (PathConstraint)pc);
        QueryValue queryValue = null;
        if (!isFilterConstraint) {
            queryValue = this.buildQueryValue(pc);
        }
        if (isFilterConstraint && !"All".equalsIgnoreCase(this.filter)) {
            queryValue = new QueryValue((Object)this.filter);
        }
        for (int index = 0; index < pathConstraintSplitted.length; ++index) {
            if (index == pathConstraintSplitted.length - 1) {
                qfConstraint = new QueryField(qc, pathConstraintSplitted[index]);
                if (queryValue == null) continue;
                if (!"null".equalsIgnoreCase(queryValue.getValue().toString())) {
                    Object qe = null;
                    qe = queryValue.getValue() instanceof String && !isFilterConstraint ? new QueryExpression(6, (QueryEvaluable)qfConstraint) : qfConstraint;
                    cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)qe, pc.getOp(), (QueryEvaluable)queryValue));
                    continue;
                }
                ConstraintOp op = pc.getOp().equals(ConstraintOp.EQUALS) ? ConstraintOp.IS_NULL : ConstraintOp.IS_NOT_NULL;
                cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)qfConstraint, op));
                continue;
            }
            String partialPath = this.createAttributePath(pathConstraintSplitted, index);
            qc = this.addReference(query, qc, pathConstraintSplitted[index], partialPath);
        }
    }

    private void buildCategorySeriesMap(HashMap<String, long[]> categorySeriesMap) {
        if (this.config.hasSeries()) {
            String[] seriesValue = this.config.getSeriesValues().split("\\,");
            block2: for (ResultsRow row : this.results) {
                String category = (String)row.get(0);
                Object series = row.get(1);
                long count = (Long)row.get(2);
                if (series == null) continue;
                if (categorySeriesMap.get(category) != null) {
                    for (int indexSeries = 0; indexSeries < seriesValue.length; ++indexSeries) {
                        if (!this.isSeriesValue(seriesValue[indexSeries], series)) continue;
                        categorySeriesMap.get((Object)category)[indexSeries] = count;
                        continue block2;
                    }
                    continue;
                }
                long[] counts = new long[seriesValue.length];
                for (int indexSeries = 0; indexSeries < seriesValue.length; ++indexSeries) {
                    if (!this.isSeriesValue(seriesValue[indexSeries], series)) continue;
                    counts[indexSeries] = count;
                    break;
                }
                categorySeriesMap.put(category, counts);
            }
        } else {
            for (ResultsRow row : this.results) {
                String category;
                try {
                    category = (String)row.get(0);
                }
                catch (ClassCastException cce) {
                    category = Integer.toString((Integer)row.get(0));
                }
                long count = (Long)row.get(1);
                long[] counts = new long[]{count};
                categorySeriesMap.put(category, counts);
            }
        }
    }

    private boolean isSeriesValue(String seriesValue, Object series) {
        if ("true".equalsIgnoreCase(seriesValue) || "false".equalsIgnoreCase(seriesValue)) {
            return Boolean.parseBoolean(seriesValue) == (Boolean)series;
        }
        return seriesValue.equals(series);
    }

    private void populateResultTable(LinkedHashMap<String, long[]> categorySeriesMap) {
        LinkedList<Object> headerRow = new LinkedList<Object>();
        LinkedList<Object> dataRow = null;
        headerRow.add(this.config.getRangeLabel());
        if (this.config.hasSeries()) {
            String[] seriesLabels = this.config.getSeriesLabels().split(",");
            for (String seriesLabel : seriesLabels) {
                headerRow.add(seriesLabel);
            }
        }
        this.resultTable.add(headerRow);
        ArrayList<String> categories = new ArrayList<String>(categorySeriesMap.keySet());
        Collections.sort(categories);
        for (String category : categories) {
            long[] seriesCounts;
            dataRow = new LinkedList<Object>();
            dataRow.add(category);
            for (long seriesCount : seriesCounts = categorySeriesMap.get(category)) {
                dataRow.add(seriesCount);
            }
            this.resultTable.add(dataRow);
        }
    }

    private void calcTotal() {
        Results res = this.os.execute(this.createQuery(GraphWidgetActionType.TOTAL));
        for (ResultsRow resRow : res) {
            this.items = ((Long)resRow.get(0)).intValue();
        }
    }

    public Results getResults() {
        return this.results;
    }

    public int getWidgetTotal() {
        return this.items;
    }

    public List<List<Object>> getResultTable() {
        return this.resultTable;
    }

    private int addExpected(Map<String, Long> resultsTable) {
        Query q = this.createQuery(GraphWidgetActionType.EXPECTED);
        if (q == null) {
            return 0;
        }
        Results res = this.os.execute(q);
        Iterator iter = res.iterator();
        int grandTotal = 0;
        while (iter.hasNext()) {
            ResultsRow resRow = (ResultsRow)iter.next();
            String chromosome = (String)resRow.get(0);
            long geneCount = (Long)resRow.get(1);
            resultsTable.put(chromosome, geneCount);
            grandTotal = (int)((long)grandTotal + geneCount);
        }
        return grandTotal;
    }

    private int addActual(HashMap<String, long[]> resultsTable) {
        Query q = this.createQuery(GraphWidgetActionType.ACTUAL);
        if (q == null) {
            return 0;
        }
        this.results = this.os.execute(q, 50000, true, true, true);
        int totalInBagWithLocation = 0;
        for (ResultsRow resRow : this.results) {
            long[] counts;
            String chromosome = (String)resRow.get(0);
            int geneCount = ((Long)resRow.get(1)).intValue();
            if (resultsTable.get(chromosome) == null) {
                counts = new long[2];
                counts[0] = geneCount;
                resultsTable.put(chromosome, counts);
            } else {
                counts = resultsTable.get(chromosome);
                counts[0] = geneCount;
            }
            totalInBagWithLocation += geneCount;
        }
        return totalInBagWithLocation;
    }

    private void buildCategorySeriesMapForActualExpectedCriteria(HashMap<String, long[]> categorySeriesMap, Map<String, Long> categoryMapInDB, int totalInBagWithLocation, int totalInDBWithLocation) {
        for (String category : categoryMapInDB.keySet()) {
            double expectedValue = 0.0;
            double proportion = 0.0;
            double totalInDBWithChromosome = categoryMapInDB.get(category).longValue();
            if (totalInDBWithChromosome > 0.0) {
                proportion = totalInDBWithChromosome / (double)totalInDBWithLocation;
            }
            expectedValue = (double)totalInBagWithLocation * proportion;
            if (categorySeriesMap.get(category) != null) {
                categorySeriesMap.get((Object)category)[1] = (int)Math.round(expectedValue);
                continue;
            }
            long[] counts = new long[]{0L, (int)Math.round(expectedValue)};
            categorySeriesMap.put(category, counts);
        }
    }
}

