/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.intermine.api.profile.InterMineBag;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.widget.TableWidgetLdr;
import org.intermine.web.logic.widget.Widget;
import org.intermine.web.logic.widget.config.TableWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;

public class TableWidget
extends Widget {
    private TableWidgetLdr bagWidgLdr;

    public TableWidget(TableWidgetConfig config, InterMineBag interMineBag, ObjectStore os, String ids) {
        super((WidgetConfig)config);
        this.bag = interMineBag;
        this.os = os;
        this.ids = ids;
    }

    public void process() {
        this.checkNotProcessed();
        try {
            this.bagWidgLdr = new TableWidgetLdr(this.config, this.bag, this.os, this.ids);
            int size = this.bag != null ? this.bag.getSize() : this.ids.split(",").length;
            this.notAnalysed = size - this.bagWidgLdr.getWidgetTotal();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ObjectStoreException e) {
            e.printStackTrace();
        }
    }

    public List getFlattenedResults() {
        this.checkProcessed();
        return this.bagWidgLdr.getFlattenedResults();
    }

    public List<List<String>> getExportResults(String[] selected) throws Exception {
        this.checkProcessed();
        return this.bagWidgLdr.getExportResults(selected);
    }

    public boolean getHasResults() {
        this.checkProcessed();
        return this.bagWidgLdr.getFlattenedResults().size() > 0;
    }

    public List getColumns() {
        this.checkProcessed();
        return this.bagWidgLdr.getColumns();
    }

    private void checkProcessed() {
        if (this.bagWidgLdr == null) {
            throw new IllegalStateException("This widget has not been processed yet.");
        }
    }

    private void checkNotProcessed() {
        if (this.bagWidgLdr != null) {
            throw new IllegalStateException("This widget has already been processed.");
        }
    }

    public List<List<Object>> getResults() {
        this.checkProcessed();
        return this.bagWidgLdr.getFlattenedResults();
    }

    public PathQuery getPathQuery() {
        this.checkProcessed();
        return this.bagWidgLdr.createPathQuery();
    }
}

