/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.pathquery.PathConstraint;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfigUtil;

public class WidgetLdr {
    protected ObjectStore os;
    protected InterMineBag bag;
    protected String ids;
    protected List<Integer> idsList;
    protected String filter;
    protected QueryClass startClass;
    private static final Logger LOG = Logger.getLogger(WidgetLdr.class);
    protected Map<String, QueryClass> queryClassInQuery;

    public WidgetLdr(InterMineBag bag, ObjectStore os, String filter, WidgetConfig config, String ids) {
        block6: {
            this.queryClassInQuery = new HashMap();
            this.bag = bag;
            this.os = os;
            this.filter = filter;
            this.ids = ids;
            try {
                this.startClass = new QueryClass(new Class[]{Class.forName(os.getModel().getPackageName() + "." + config.getStartClass())});
            }
            catch (ClassNotFoundException e) {
                if (!(config instanceof EnrichmentWidgetConfig) && !(config instanceof GraphWidgetConfig)) break block6;
                throw new IllegalArgumentException("Not found the class set in startClass for the widget " + config.getId(), e);
            }
        }
        if (ids != null) {
            this.idsList = new ArrayList();
            String[] idStrings = ids.split(",");
            for (int i = 0; i < idStrings.length; ++i) {
                try {
                    this.idsList.add(Integer.parseInt(idStrings[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Bad IDs for the widget");
                }
            }
        }
    }

    protected QueryValue buildQueryValue(PathConstraint pc) {
        String value = PathConstraint.getValue((PathConstraint)pc);
        QueryValue queryValue = null;
        if ("true".equalsIgnoreCase(value)) {
            queryValue = new QueryValue((Object)true);
        } else if ("false".equalsIgnoreCase(value)) {
            queryValue = new QueryValue((Object)false);
        } else if (!NumberUtils.isNumber((String)value)) {
            queryValue = new QueryValue((Object)value);
        } else {
            try {
                queryValue = new QueryValue((Object)Integer.parseInt(value));
            }
            catch (NumberFormatException nfe) {
                queryValue = new QueryValue((Object)Double.parseDouble(value));
            }
        }
        return queryValue;
    }

    protected QueryField createQueryFieldByPath(String path, Query query, boolean addToSelect) {
        QueryField queryField = null;
        String[] splittedPath = path.split("\\.");
        QueryClass qc = this.startClass;
        String attributePath = "";
        for (int i = 0; i < splittedPath.length; ++i) {
            String attribute = splittedPath[i];
            if (i == splittedPath.length - 1) {
                queryField = new QueryField(qc, attribute);
                if (!addToSelect) continue;
                query.addToSelect((QuerySelectable)queryField);
                query.addToGroupBy((QueryNode)queryField);
                query.addToOrderBy((QueryOrderable)queryField);
                continue;
            }
            attributePath = this.createAttributePath(splittedPath, i);
            qc = this.addReference(query, qc, attribute, attributePath);
        }
        return queryField;
    }

    protected QueryClass addReference(Query query, QueryClass qc, String attribute, String attributePath) {
        QueryClass ret;
        ConstraintSet cs = (ConstraintSet)query.getConstraint();
        QueryObjectReference qr = null;
        String type = "";
        boolean useSubClass = false;
        if (WidgetConfigUtil.isPathContainingSubClass((Model)this.os.getModel(), (String)attribute)) {
            useSubClass = true;
            type = attribute.substring(attribute.indexOf("[") + 1, attribute.indexOf("]"));
            attribute = attribute.substring(0, attribute.indexOf("["));
        }
        QueryClass qcTmp = null;
        try {
            qr = new QueryObjectReference(qc, attribute);
            if (useSubClass) {
                try {
                    qcTmp = new QueryClass(new Class[]{Class.forName(this.os.getModel().getPackageName() + "." + type)});
                }
                catch (ClassNotFoundException cnfe) {
                    LOG.error((Object)("The type " + type + " doesn't exist in the model."));
                }
            } else {
                qcTmp = new QueryClass(new Class[]{qr.getType()});
            }
        }
        catch (IllegalArgumentException e) {
            qr = new QueryCollectionReference(qc, attribute);
            if (useSubClass) {
                try {
                    qcTmp = new QueryClass(new Class[]{Class.forName(this.os.getModel().getPackageName() + "." + type)});
                }
                catch (ClassNotFoundException cnfe) {
                    LOG.error((Object)("The type " + type + " doesn't exist in the model."));
                }
            }
            qcTmp = new QueryClass(TypeUtil.getElementType((Class)qc.getType(), (String)attribute));
        }
        if (!this.queryClassInQuery.containsKey(attributePath)) {
            ret = qcTmp;
            query.addFrom((FromElement)ret);
            cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qr, ConstraintOp.CONTAINS, ret));
            this.queryClassInQuery.put(attributePath, ret);
        } else {
            ret = (QueryClass)this.queryClassInQuery.get(attributePath);
        }
        return ret;
    }

    protected String createAttributePath(String[] paths, int index) {
        String partialPath = this.startClass.getType().getSimpleName();
        for (int partialPathIndex = 0; partialPathIndex <= index; ++partialPathIndex) {
            String path = paths[partialPathIndex];
            if (path.contains("[")) {
                path = path.substring(0, path.indexOf("["));
            }
            partialPath = partialPath + "." + path;
        }
        return partialPath;
    }
}

