/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.intermine.util.PropertiesUtil;
import org.intermine.web.logic.ResourceOpener;
import org.intermine.web.security.Base64PublicKeyDecoder;
import org.intermine.web.security.DecodingException;
import org.intermine.web.security.KeySigner;

public class KeyStoreBuilder {
    private static final String CANT_GEN_CERT = "Could not generate certificate for ";
    private static final Logger LOG = Logger.getLogger(KeyStoreBuilder.class);
    private static final String DEFAULT_TITLE = "InterMine";
    private static final String PROJECT_TITLE = "project.title";
    private static final String SECURITY_PRIVATEKEY_ALIAS = "security.privatekey.alias";
    private static final String SECURITY_PRIVATEKEY_PASSWORD = "security.privatekey.password";
    private static final String KS_PASSWORD = "security.keystore.password";
    private static final String PREFIX = "security.publickey";
    private static final String STRICT_DECODING = "keystore.strictpublickeydecoding";
    private Properties options;
    private ResourceOpener opener;

    public KeyStoreBuilder(Properties options, ResourceOpener opener) {
        this.options = options;
        this.opener = opener;
        if (options == null) {
            throw new NullPointerException("options must not be null");
        }
        if (opener == null) {
            throw new NullPointerException("opener must not be null");
        }
    }

    private char[] getKeyStorePassword() {
        String password = this.options.getProperty(KS_PASSWORD);
        if (password != null) {
            return password.toCharArray();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore buildKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance("JKS");
        InputStream is = null;
        try {
            is = this.opener.openResource("keystore.jks");
            if (is == null) {
                LOG.debug((Object)"NO KEYSTORE FOUND - initialising empty keystore");
            } else {
                LOG.debug((Object)"FOUND KEYSTORE");
            }
            store.load(is, this.getKeyStorePassword());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Error closing keystore resource", (Throwable)e);
                }
            }
        }
        Map publicKeys = this.getConfiguredPublicKeys();
        if (!publicKeys.isEmpty()) {
            LOG.info((Object)("Found " + publicKeys.size() + " encoded keys"));
            String dn = "CN=" + this.options.getProperty(PROJECT_TITLE, DEFAULT_TITLE);
            dn = dn.replaceAll("\\s", "");
            int oneYear = 365;
            String alias = this.options.getProperty(SECURITY_PRIVATEKEY_ALIAS);
            PrivateKey signingKey = this.getOrGeneratePrivateKey(store, alias);
            KeySigner signer = new KeySigner(signingKey, dn, oneYear, "SHA256withRSA");
            for (Map.Entry pair : publicKeys.entrySet()) {
                try {
                    store.setCertificateEntry((String)pair.getKey(), signer.generateCertificate((String)pair.getKey(), (PublicKey)pair.getValue()));
                }
                catch (KeySigner.SigningException e) {
                    throw new CertificateException(CANT_GEN_CERT + (String)pair.getKey());
                }
            }
        }
        int n = 0;
        Enumeration<String> es = store.aliases();
        while (es.hasMoreElements()) {
            ++n;
            es.nextElement();
        }
        LOG.debug((Object)("Finished configuring KEYSTORE - it contains " + n + " certificates"));
        return store;
    }

    private PrivateKey getOrGeneratePrivateKey(KeyStore store, String alias) throws KeyStoreException, NoSuchAlgorithmException {
        PrivateKey signingKey = null;
        if (alias != null && store.containsAlias(alias)) {
            String password = this.options.getProperty(SECURITY_PRIVATEKEY_PASSWORD);
            try {
                signingKey = (PrivateKey)store.getKey(alias, password != null ? password.toCharArray() : null);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                // empty catch block
            }
        }
        if (signingKey == null) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            KeyPair keyPair = keyGen.genKeyPair();
            signingKey = keyPair.getPrivate();
        }
        return signingKey;
    }

    private Map<String, PublicKey> getConfiguredPublicKeys() {
        Properties ps = PropertiesUtil.stripStart((String)PREFIX, (Properties)this.options);
        Base64PublicKeyDecoder decoder = new Base64PublicKeyDecoder();
        boolean skipBadKeys = !"true".equalsIgnoreCase(this.options.getProperty(STRICT_DECODING));
        HashMap<String, PublicKey> retVal = new HashMap<String, PublicKey>();
        Enumeration<?> names = ps.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            LOG.info((Object)("found encoded key called " + name));
            try {
                PublicKey key = decoder.decode(ps.getProperty(name));
                retVal.put(name, key);
            }
            catch (DecodingException e) {
                String msg = "Could not decode key for " + name;
                if (skipBadKeys) {
                    LOG.error((Object)msg);
                    continue;
                }
                throw new RuntimeException(msg, e);
            }
        }
        return retVal;
    }
}

