/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.text.MessageFormat;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.intermine.util.MailUtils;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ContactForm;
import org.intermine.web.struts.InterMineAction;

public class ContactAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(ContactAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ContactForm ff = (ContactForm)form;
        try {
            Properties webProperties = SessionMethods.getWebProperties((ServletContext)session.getServletContext());
            MessageResources strings = this.getResources(request);
            String from = ff.getMonkey();
            String subject = ff.getSubject();
            String body = MessageFormat.format(strings.getMessage("contact.template"), ff.getName(), ff.getMonkey(), ff.getMessage());
            String dest = webProperties.getProperty("feedback.destination");
            MailUtils.email((String)dest, (String)subject, (String)body, (String)from, (Properties)webProperties);
            this.recordMessage(new ActionMessage("contact.sent"), request);
            request.setAttribute("sent", (Object)Boolean.TRUE);
            ff.reset(mapping, request);
        }
        catch (Exception e) {
            request.setAttribute("response", (Object)e);
            this.recordError(new ActionMessage("contact.failed", (Object)e), request, e, LOG);
        }
        return mapping.findForward("contact");
    }
}

