/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.SavedQuery;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.objectstore.query.Query;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.util.XmlUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.util.URLGenerator;
import org.intermine.webservice.server.query.result.QueryResultLinkGenerator;

public class ExportQueryAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(ExportQueryAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SavedQuery sq;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        String type = request.getParameter("type");
        String name = request.getParameter("name");
        PathQuery query = null;
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)name)) {
            query = SessionMethods.getQuery((HttpSession)session);
        } else if ("history".equals(type)) {
            sq = (SavedQuery)profile.getHistory().get(name);
            if (sq == null) {
                this.recordError(new ActionMessage("errors.query.missing", (Object)name), request);
                return mapping.findForward("mymine");
            }
            query = sq.getPathQuery();
        } else if ("saved".equals(type)) {
            sq = (SavedQuery)profile.getSavedQueries().get(name);
            if (sq == null) {
                this.recordError(new ActionMessage("errors.query.missing", (Object)name), request);
                return mapping.findForward("mymine");
            }
            query = sq.getPathQuery();
        } else {
            LOG.error((Object)("Bad type parameter: " + type));
            return null;
        }
        if (query == null) {
            LOG.error((Object)("Failed to find query " + name + " of type " + type));
            return null;
        }
        if (query.getView().size() == 0) {
            response.getWriter().write("Invalid query. No fields selected for output.");
            return null;
        }
        response.setContentType("text/plain; charset=utf-8");
        WebResultsExecutor webResultsExecutor = im.getWebResultsExecutor(profile);
        String format = !StringUtils.isEmpty((String)request.getParameter("as")) ? request.getParameter("as").toLowerCase() : "xml";
        if ("xml".equals(format)) {
            String xml = this.getQueryXML(name, query);
            xml = XmlUtil.indentXmlSimple((String)xml);
            response.getWriter().write(xml);
        } else if ("iql".equals(format)) {
            Query osQuery = webResultsExecutor.makeQuery(query);
            response.getWriter().println(osQuery.toString());
        } else if ("sql".equals(format)) {
            response.getWriter().println(webResultsExecutor.makeSql(query));
        } else if ("link".equals(format)) {
            String serviceFormat = request.getParameter("serviceFormat") != null ? request.getParameter("serviceFormat") : "tab";
            String xml = this.getQueryXML(name, query);
            String link = new QueryResultLinkGenerator().getLink(new URLGenerator(request).getPermanentBaseURL(), xml, serviceFormat);
            response.getWriter().write(link);
        } else {
            response.getWriter().println("Unknown export type: " + request.getParameter("as"));
        }
        return null;
    }

    private String getQueryXML(String name, PathQuery query) {
        String modelName = query.getModel().getName();
        return PathQueryBinding.marshal((PathQuery)query, (String)(name != null ? name : ""), (String)modelName, (int)2);
    }
}

