/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.bag.SharingInvite;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.UserAlreadyShareBagException;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.InvitationAction;
import org.intermine.web.struts.InvitationForm;

public class InvitationAction
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(InvitationAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InvitationForm inviteForm = (InvitationForm)form;
        InterMineAPI api = SessionMethods.getInterMineAPI((HttpServletRequest)request);
        SharedBagManager sbm = SharedBagManager.getInstance((ProfileManager)api.getProfileManager());
        ProfileManager pm = api.getProfileManager();
        Profile p = SessionMethods.getProfile((HttpSession)request.getSession());
        Properties props = SessionMethods.getWebProperties((HttpServletRequest)request);
        if (!p.isLoggedIn()) {
            ActionMessage message = new ActionMessage("invitation-errors.mustlogin");
            this.recordMessage(message, request);
            ForwardParameters fp = new ForwardParameters(mapping.findForward("login"));
            fp.addParameter("returnto", "/accept.do?invite=" + inviteForm.getInvite());
            return fp.forward();
        }
        SharingInvite invite = null;
        try {
            invite = SharingInvite.getByToken((InterMineAPI)api, (String)inviteForm.getInvite());
            sbm.acceptInvitation(invite, p);
            this.notifyInvitee(pm, invite, p, props);
            return this.forwardToBagDetails(mapping, invite);
        }
        catch (UserAlreadyShareBagException e) {
            this.sendErrorMsg(request, (Exception)((Object)e), "invitation-errors.alreadyshared", new Object[0]);
            return this.forwardToBagDetails(mapping, invite);
        }
        catch (IllegalStateException e) {
            this.sendErrorMsg(request, (Exception)e, "invitation-errors.couldntaccept", new Object[]{e.getMessage()});
        }
        catch (SharingInvite.NotFoundException e) {
            this.sendErrorMsg(request, (Exception)((Object)e), "invitation-errors.couldntretrieve", new Object[0]);
        }
        return mapping.findForward("mymine");
    }

    private void notifyInvitee(ProfileManager pm, SharingInvite invite, Profile accepter, Properties props) {
        1 action = new /* Unavailable Anonymous Inner Class!! */;
        boolean queued = InterMineContext.queueMessage((MailAction)action);
        if (!queued) {
            LOG.warn((Object)"Mail queue is full - could not send message");
        }
    }

    private ActionForward forwardToBagDetails(ActionMapping mapping, SharingInvite invite) {
        ForwardParameters forwardParameters = new ForwardParameters(mapping.findForward("bagDetails"));
        forwardParameters.addParameter("name", invite.getBag().getName());
        return forwardParameters.forward();
    }

    private void sendErrorMsg(HttpServletRequest request, Exception e, String key, Object ... vals) {
        this.recordError(new ActionMessage(key, vals), request, e, LOG);
    }
}

