/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebTable;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplatePopulator;
import org.intermine.api.util.NameUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplatePopulatorException;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.bag.BagHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.http.TableExporterFactory;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.logic.template.TemplateResultInput;
import org.intermine.web.logic.template.Templates;
import org.intermine.web.struts.ForwardParameters;

public class LoadTemplateAction
extends DispatchAction {
    private TemplateQuery parseTemplate(HttpServletRequest request, InterMineAPI im) {
        Map templateValues;
        String name = request.getParameter("name");
        TemplateResultInput input = new TemplateResultInput();
        try {
            input.setConstraints(Templates.parseConstraints((HttpServletRequest)request));
        }
        catch (Templates.TemplateValueParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        input.setName(name);
        TemplateManager templateManager = im.getTemplateManager();
        ApiTemplate template = templateManager.getGlobalTemplate(name);
        if (template == null) {
            throw new RuntimeException("template not found: " + name);
        }
        try {
            templateValues = Templates.getValuesFromInput((TemplateQuery)template, (TemplateResultInput)input);
        }
        catch (Templates.TemplateValueParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            template = TemplatePopulator.getPopulatedTemplate((TemplateQuery)template, (Map)templateValues);
        }
        catch (TemplatePopulatorException e) {
            throw new RuntimeException("Error in applying constraint values to template: " + name);
        }
        return template;
    }

    public ActionForward results(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        TemplateQuery template = this.parseTemplate(request, im);
        SessionMethods.loadQuery((PathQuery)template, (HttpSession)session, (HttpServletResponse)response);
        SessionMethods.logQuery((HttpSession)request.getSession());
        return new ForwardParameters(mapping.findForward("results")).forward();
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        TemplateQuery template = this.parseTemplate(request, im);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        String path = request.getParameter("path");
        String bagName = template.getName() + "_results";
        bagName = NameUtil.generateNewName(profile.getSavedBags().keySet(), (String)bagName);
        BagHelper.createBagFromPathQuery((PathQuery)template, (String)bagName, (String)template.getDescription(), (String)path, (Profile)profile, (InterMineAPI)im);
        ForwardParameters forwardParameters = new ForwardParameters(mapping.findForward("bagDetails"));
        return forwardParameters.addParameter("bagName", bagName).forward();
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        String exportFormat = request.getParameter("format");
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        PagedTable pt = null;
        TemplateQuery template = this.parseTemplate(request, im);
        WebResultsExecutor executor = im.getWebResultsExecutor(profile);
        try {
            pt = new PagedTable((WebTable)executor.execute((PathQuery)template));
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("couldn't execute template:" + template.getName(), e);
        }
        WebConfig webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        TableExporterFactory factory = new TableExporterFactory(webConfig);
        TableHttpExporter exporter = null;
        try {
            exporter = factory.getExporter(exportFormat);
        }
        catch (Exception e) {
            throw new RuntimeException("bad exporter", e);
        }
        if (exporter == null) {
            throw new RuntimeException("unknown export format: " + exportFormat);
        }
        exporter.export(pt, request, response, null, null, null);
        return null;
    }
}

