/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.bag.BagOperations;
import org.intermine.api.bag.ClassKeysNotFoundException;
import org.intermine.api.bag.UnknownBagTypeException;
import org.intermine.api.bag.operations.BagOperationException;
import org.intermine.api.bag.operations.InternalBagOperationException;
import org.intermine.api.bag.operations.NoContent;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.SavedQuery;
import org.intermine.api.tracker.util.ListBuildMode;
import org.intermine.api.types.ClassKeys;
import org.intermine.api.util.NameUtil;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.ModifyBagForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModifyBagAction
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(InterMineAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModifyBagForm mbf = (ModifyBagForm)form;
        String[] selectedBagNames = mbf.getSelectedBags();
        if (selectedBagNames.length == 0) {
            this.recordError(new ActionMessage("errors.bag.listnotselected"), request);
            return ModifyBagAction.getReturn((String)mbf.getPageName(), (ActionMapping)mapping);
        }
        if (request.getParameter("union") != null || mbf.getListsButton() != null && "union".equals(mbf.getListsButton())) {
            this.combine(form, request, "UNION");
        } else if (request.getParameter("intersect") != null || mbf.getListsButton() != null && "intersect".equals(mbf.getListsButton())) {
            this.combine(form, request, "INTERSECT");
        } else if (request.getParameter("subtract") != null || mbf.getListsButton() != null && "subtract".equals(mbf.getListsButton())) {
            this.combine(form, request, "SUBTRACT");
        } else if (request.getParameter("delete") != null || mbf.getListsButton() != null && "delete".equals(mbf.getListsButton())) {
            ModifyBagAction.delete((ActionForm)form, (HttpServletRequest)request);
        } else if (request.getParameter("copy") != null || mbf.getListsButton() != null && "copy".equals(mbf.getListsButton())) {
            this.copy(form, request);
        } else if (mbf.getListsButton() != null && "asymmetricdifference".equals(mbf.getListsButton().trim())) {
            this.combine(form, request, "ASYMMETRIC_SUBTRACT");
        }
        return ModifyBagAction.getReturn((String)mbf.getPageName(), (ActionMapping)mapping);
    }

    private static String getNewNameTextBox(HttpServletRequest request, String newBagName) {
        Properties properties = SessionMethods.getWebProperties((ServletContext)request.getSession().getServletContext());
        String exampleName = properties.getProperty("lists.input.example");
        if (StringUtils.isEmpty((String)newBagName) || newBagName.equalsIgnoreCase(exampleName)) {
            return null;
        }
        return newBagName;
    }

    private void copy(ActionForm form, HttpServletRequest request) throws UnknownBagTypeException, ClassKeysNotFoundException, ObjectStoreException {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        ModifyBagForm frm = (ModifyBagForm)form;
        String[] selectedBagNames = frm.getSelectedBags();
        BagManager bagManager = im.getBagManager();
        Map allBags = bagManager.getBags(profile);
        String newNameTextBox = ModifyBagAction.getNewNameTextBox((HttpServletRequest)request, (String)frm.getNewBagName());
        if (selectedBagNames.length == 1) {
            String selectedBagName = selectedBagNames[0];
            InterMineBag origBag = (InterMineBag)allBags.get(selectedBagName);
            if (origBag == null) {
                this.recordError(new ActionMessage("errors.bag.notfound"), request);
                return;
            }
            String newBagName = "";
            if (newNameTextBox != null && (newBagName = NameUtil.validateName(allBags.keySet(), (String)newNameTextBox)).isEmpty()) {
                this.recordError(new ActionMessage("bag.createdlists.notvalidname", (Object)newNameTextBox), request);
                return;
            }
            if (newNameTextBox == null) {
                newBagName = NameUtil.generateNewName(allBags.keySet(), (String)selectedBagName);
            }
            if (ModifyBagAction.createBag((InterMineBag)origBag, (String)newBagName, (Profile)profile, (InterMineAPI)im)) {
                this.recordMessage(new ActionMessage("bag.createdlists", (Object)newBagName), request);
                im.getTrackerDelegate().trackListCreation(origBag.getType(), origBag.getSize(), ListBuildMode.OPERATION, profile, session.getId());
            }
        } else {
            if (newNameTextBox != null) {
                this.recordError(new ActionMessage("errors.bag.namecannotbespecified"), request);
                return;
            }
            String msg = "";
            for (int i = 0; i < selectedBagNames.length; ++i) {
                String selectedBagName = selectedBagNames[i];
                InterMineBag origBag = (InterMineBag)allBags.get(selectedBagName);
                if (origBag == null) {
                    this.recordError(new ActionMessage("errors.bag.notfound"), request);
                    return;
                }
                String newBagName = NameUtil.generateNewName(allBags.keySet(), (String)selectedBagName);
                if (!ModifyBagAction.createBag((InterMineBag)origBag, (String)newBagName, (Profile)profile, (InterMineAPI)im)) continue;
                msg = msg + newBagName + ", ";
            }
            if (msg.length() > 2) {
                msg = msg.substring(0, msg.length() - 2);
            }
            if (msg.length() > 0) {
                this.recordMessage(new ActionMessage("bag.createdlists", (Object)msg), request);
            }
        }
    }

    private static boolean createBag(InterMineBag origBag, String newBagName, Profile profile, InterMineAPI im) throws UnknownBagTypeException, ClassKeysNotFoundException, ObjectStoreException {
        InterMineBag newBag = profile.createBag(newBagName, origBag.getType(), origBag.getDescription(), (Map)im.getClassKeys());
        newBag.addIdsToBag((Collection)origBag.getContentsAsIds(), origBag.getType());
        profile.saveBag(newBagName, newBag);
        return true;
    }

    private void combine(ActionForm form, HttpServletRequest request, String opText) {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        ModifyBagForm mbf = (ModifyBagForm)form;
        BagManager bagManager = im.getBagManager();
        Map allBags = bagManager.getBags(profile);
        String[] selectedBagNames = mbf.getSelectedBags();
        Collection selectedBags = ModifyBagAction.getSelectedBags((Map)allBags, (String[])selectedBagNames);
        String newBagName = NameUtil.validateName(allBags.keySet(), (String)mbf.getNewBagName());
        int newBagSize = 0;
        Model model = im.getModel();
        try {
            if (opText.equals("UNION")) {
                newBagSize = BagOperations.union((Model)model, (Collection)selectedBags, (String)newBagName, (Profile)profile, (ClassKeys)im.getClassKeys());
            } else if (opText.equals("INTERSECT")) {
                newBagSize = BagOperations.intersect((Model)model, (Collection)selectedBags, (String)newBagName, (Profile)profile, (ClassKeys)im.getClassKeys());
            } else if (opText.equals("SUBTRACT")) {
                newBagSize = BagOperations.subtract((Model)model, (Collection)selectedBags, (String)newBagName, (Profile)profile, (ClassKeys)im.getClassKeys());
            } else if (opText.equals("ASYMMETRIC_SUBTRACT")) {
                ArrayList<InterMineBag> include = new ArrayList<InterMineBag>();
                include.add((InterMineBag)allBags.get(mbf.getListLeft()));
                ArrayList<InterMineBag> exclude = new ArrayList<InterMineBag>();
                exclude.add((InterMineBag)allBags.get(mbf.getListRight()));
                newBagSize = BagOperations.asymmetricSubtract((Model)model, include, exclude, (String)newBagName, (Profile)profile, (ClassKeys)im.getClassKeys());
            }
        }
        catch (MetaDataException e) {
            SessionMethods.recordError((String)("Incompatible list types. Lists " + StringUtil.prettyList(Arrays.asList(selectedBagNames)) + " do not match."), (HttpSession)session);
            return;
        }
        catch (InternalBagOperationException e) {
            LOG.error((Object)e);
            ActionMessage actionMessage = new ActionMessage("An error occurred while saving the list");
            this.recordError(actionMessage, request);
            return;
        }
        catch (NoContent nc) {
            SessionMethods.recordError((String)(opText + " operation on lists " + StringUtil.prettyList(Arrays.asList(selectedBagNames)) + " produced no results."), (HttpSession)session);
            return;
        }
        catch (BagOperationException e) {
            SessionMethods.recordError((String)e.getMessage(), (HttpSession)session);
            return;
        }
        if (newBagSize > 0) {
            InterMineBag created = im.getBagManager().getBag(profile, newBagName);
            if (created == null) {
                SessionMethods.recordError((String)"An unknown error occured.", (HttpSession)session);
                return;
            }
            SessionMethods.recordMessage((String)("Created list \"" + newBagName + "\" as " + opText + " of  " + StringUtil.prettyList(Arrays.asList(selectedBagNames)) + "."), (HttpSession)session);
            im.getTrackerDelegate().trackListCreation(created.getType(), newBagSize, ListBuildMode.OPERATION, profile, session.getId());
        }
    }

    private static Collection<InterMineBag> getSelectedBags(Map<String, InterMineBag> allBags, String[] selectedBagNames) {
        HashSet<InterMineBag> selectedBags = new HashSet<InterMineBag>();
        for (String bagName : selectedBagNames) {
            selectedBags.add(allBags.get(bagName));
        }
        return selectedBags;
    }

    private static void delete(ActionForm form, HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        ModifyBagForm mbf = (ModifyBagForm)form;
        for (int i = 0; i < mbf.getSelectedBags().length; ++i) {
            String bagName = mbf.getSelectedBags()[i];
            InterMineBag bag = (InterMineBag)profile.getSavedBags().get(bagName);
            if (bag != null) {
                ModifyBagAction.deleteQueriesThatMentionBag((Profile)profile, (String)bag.getName());
                ModifyBagAction.deleteBag((HttpSession)session, (Profile)profile, (InterMineBag)bag);
                continue;
            }
            bag = (InterMineBag)profile.getSharedBags().get(bagName);
            if (bag == null) {
                LOG.error((Object)"Asked to delete a bag this user does not have access to.");
                continue;
            }
            ModifyBagAction.unshareBag((HttpSession)session, (Profile)profile, (InterMineBag)bag);
        }
    }

    private static void unshareBag(HttpSession session, Profile profile, InterMineBag bag) {
        InterMineAPI api = SessionMethods.getInterMineAPI((HttpSession)session);
        BagManager bm = api.getBagManager();
        bm.unshareBagWithUser(bag, profile);
    }

    private static void deleteBag(HttpSession session, Profile profile, InterMineBag bag) throws ObjectStoreException {
        SessionMethods.invalidateBagTable((HttpSession)session, (String)bag.getName());
        profile.deleteBag(bag.getName());
    }

    private static ActionForward getReturn(String pageName, ActionMapping mapping) {
        if (pageName != null && "MyMine".equals(pageName)) {
            return new ForwardParameters(mapping.findForward("mymine")).addParameter("subtab", "lists").forward();
        }
        return new ForwardParameters(mapping.findForward("bag")).addParameter("subtab", "view").forward();
    }

    private static void deleteQueriesThatMentionBag(Profile profile, String bagName) {
        SavedQuery query;
        Map savedQueries = profile.getHistory();
        HashSet savedQueriesNames = new HashSet(profile.getHistory().keySet());
        for (String queryName : savedQueriesNames) {
            query = (SavedQuery)savedQueries.get(queryName);
            if (!query.getPathQuery().getBagNames().contains(bagName)) continue;
            profile.deleteHistory(queryName);
        }
        savedQueries = profile.getSavedQueries();
        savedQueriesNames = new HashSet(profile.getSavedQueries().keySet());
        for (String queryName : savedQueriesNames) {
            query = (SavedQuery)savedQueries.get(queryName);
            if (!query.getPathQuery().getBagNames().contains(bagName)) continue;
            profile.deleteQuery(queryName);
        }
    }
}

