/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ObjectTrailController;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectTrailController
extends TilesAction {
    protected static final Logger LOG = Logger.getLogger(ObjectTrailController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ObjectStore os = im.getObjectStore();
        String trail = request.getParameter("trail");
        String queryBuilder = request.getParameter("queryBuilder");
        String[] ids = null;
        if (StringUtils.isEmpty((String)trail)) {
            ids = new String[]{};
        } else {
            trail = URLDecoder.decode(trail, "UTF-8");
            ids = StringUtils.split((String)trail.substring(1), (char)'|');
        }
        ArrayList<TrailElement> elements = new ArrayList<TrailElement>();
        String elementTrail = "";
        for (int i = 0; i < ids.length; ++i) {
            elementTrail = elementTrail + "%7C" + ids[i];
            String urlParam = ids[i];
            String[] breadcrumbs = StringUtils.split((String)urlParam, (char)'.');
            if ("bag".equals(breadcrumbs[0])) {
                ArrayList<String> bagName = new ArrayList<String>();
                for (int j = 1; j < breadcrumbs.length; ++j) {
                    bagName.add(breadcrumbs[j].replaceAll(" ", "+"));
                }
                String[] newBreadcrumbs = new String[]{"bag", StringUtils.join(bagName, (String)".")};
                breadcrumbs = newBreadcrumbs;
            }
            if ("results".equals(breadcrumbs[0])) {
                String resultsTableId = breadcrumbs[1];
                String prepend = "";
                if (resultsTableId.startsWith("itt")) {
                    String table = breadcrumbs[1] + "." + breadcrumbs[2] + "." + breadcrumbs[3];
                    elements.add(new TrailElement(table, elementTrail, "results", null));
                    continue;
                }
                try {
                    Integer.parseInt(resultsTableId);
                    prepend = "results.";
                }
                catch (Exception table) {
                    // empty catch block
                }
                String tableId = "";
                for (int j = 1; j < breadcrumbs.length; ++j) {
                    tableId = tableId + breadcrumbs[j];
                    if (j >= breadcrumbs.length - 1) continue;
                    tableId = tableId + ".";
                }
                elements.add(new TrailElement(prepend + tableId, elementTrail, "results", null));
                continue;
            }
            if ("bag".equals(breadcrumbs[0])) {
                elements.add(new TrailElement(breadcrumbs[1], elementTrail, "bag", null));
                continue;
            }
            if ("query".equals(breadcrumbs[0])) {
                elements.add(new TrailElement("query", elementTrail, "query", null));
                continue;
            }
            InterMineObject o = null;
            try {
                o = os.getObjectById(new Integer(breadcrumbs[0]));
            }
            catch (NumberFormatException err) {
                LOG.warn((Object)("bad object id " + breadcrumbs[0]));
                continue;
            }
            if (o == null) {
                LOG.warn((Object)("failed to getObjectById " + breadcrumbs[0]));
                continue;
            }
            String label = ObjectTrailController.createTrailLabel((InterMineObject)o, (Model)os.getModel());
            elements.add(new TrailElement(label, elementTrail, o.getId().intValue(), null));
        }
        request.setAttribute("trailElements", elements);
        if (queryBuilder != null) {
            request.setAttribute("queryBuilder", (Object)queryBuilder);
        }
        return null;
    }

    protected static String createTrailLabel(InterMineObject object, Model model) {
        return StringUtils.trim((String)model.getClassDescriptorByName(DynamicUtil.getSimpleClassName((FastPathObject)object)).getUnqualifiedName());
    }
}

