/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.AdditionalConverter;
import org.intermine.api.bag.BagQueryConfig;
import org.intermine.api.bag.BagQueryResult;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.idresolution.IDResolver;
import org.intermine.api.idresolution.Job;
import org.intermine.api.idresolution.JobInput;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebResults;
import org.intermine.api.util.NameUtil;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.PortalHelper;
import org.intermine.web.logic.bag.BagConverter;
import org.intermine.web.logic.bag.WebJobInput;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.BuildBagForm;
import org.intermine.web.struts.DisplayLookupMessageHandler;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalQueryAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Properties properties;
        String welcomeMsg;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ServletContext servletContext = session.getServletContext();
        String origin = request.getParameter("origin");
        String className = request.getParameter("class");
        String extId = request.getParameter("externalid");
        if (StringUtils.isBlank((String)extId)) {
            extId = request.getParameter("externalids");
        }
        String extraFieldValue = request.getParameter("extraValue");
        boolean goToListUpload = false;
        if ("true".equalsIgnoreCase(request.getParameter("goToListUpload"))) {
            goToListUpload = true;
        }
        if (StringUtils.isEmpty((String)(welcomeMsg = (properties = SessionMethods.getWebProperties((ServletContext)servletContext)).getProperty("portal.welcome." + origin)))) {
            welcomeMsg = properties.getProperty("portal.welcome");
        }
        if (!StringUtils.isBlank((String)welcomeMsg)) {
            SessionMethods.recordMessage((String)welcomeMsg, (HttpSession)session);
        }
        if (StringUtils.isBlank((String)extId)) {
            this.recordError(new ActionMessage("errors.badportalidentifiers"), request);
            return mapping.findForward("failure");
        }
        String[] idList = extId.split(",");
        if (idList.length == 1 && (className == null || className.length() == 0)) {
            String defaultClass = properties.getProperty("webapp.portal.defaultClass");
            BagQueryRunner bagRunner = im.getBagQueryRunner();
            BagQueryResult bqr = bagRunner.searchForBag(defaultClass, Arrays.asList(idList), extraFieldValue, false);
            Map matches = bqr.getMatches();
            Map issues = bqr.getIssues();
            if (matches.isEmpty() && issues.isEmpty()) {
                return new ForwardParameters(mapping.findForward("noResults")).forward();
            }
            Iterator iterator = matches.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String id = ((Integer)entry.getKey()).toString();
                return new ForwardParameters(mapping.findForward("report")).addParameter("id", id).forward();
            }
            for (Map.Entry issue : issues.entrySet()) {
                Set queryType = ((Map)issue.getValue()).keySet();
                for (String qt : queryType) {
                    Object obj = ((List)((Map)((Map)issue.getValue()).get(qt)).get(idList[0])).get(0);
                    String ob = obj.toString().substring(obj.toString().indexOf(91) + 1);
                    String id = null;
                    String[] result = ob.split(", ");
                    for (String token : result) {
                        String[] pair = token.split("=");
                        if (!"id".equalsIgnoreCase(pair[0])) continue;
                        id = pair[1].replaceAll("\"", "").replaceAll("]", "");
                        return new ForwardParameters(mapping.findForward("report")).addParameter("id", id).forward();
                    }
                }
            }
        }
        Model model = im.getModel();
        WebConfig webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        BagQueryConfig bagQueryConfig = im.getBagQueryConfig();
        if (model.getClassDescriptorByName(className = StringUtil.capitalise((String)className)) == null) {
            this.recordError(new ActionMessage("errors.badportalclass"), request);
            return PortalQueryAction.goToNoResults((ActionMapping)mapping);
        }
        PathQuery pathQuery = new PathQuery(model);
        pathQuery.addViews((Collection)PathQueryResultHelper.getDefaultViewForClass((String)className, (Model)model, (WebConfig)webConfig, null));
        pathQuery.addConstraint((PathConstraint)Constraints.lookup((String)className, (String)extId, (String)extraFieldValue));
        HashMap returnBagQueryResults = new HashMap();
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        WebResultsExecutor executor = im.getWebResultsExecutor(profile);
        WebResults webResults = executor.execute(pathQuery, returnBagQueryResults);
        String bagName = NameUtil.generateNewName(profile.getSavedBags().keySet(), (String)"link");
        ArrayList bagList = new ArrayList();
        BagQueryResult bagQueryResult = (BagQueryResult)returnBagQueryResults.values().iterator().next();
        if (!goToListUpload || idList.length == 1) {
            bagList.addAll(bagQueryResult.getMatchAndIssueIds());
        }
        DisplayLookupMessageHandler.handleMessages((BagQueryResult)bagQueryResult, (HttpSession)session, (Properties)properties, (String)className, null);
        ActionMessages actionMessages = new ActionMessages();
        Set additionalConverters = bagQueryConfig.getAdditionalConverters(className);
        if (additionalConverters != null) {
            for (AdditionalConverter additionalConverter : additionalConverters) {
                String extraValue = PortalHelper.getAdditionalParameter((HttpServletRequest)request, (String)additionalConverter.getUrlField());
                if (!StringUtils.isNotEmpty((String)extraValue)) continue;
                BagConverter bagConverter = PortalHelper.getBagConverter((InterMineAPI)im, (WebConfig)webConfig, (String)additionalConverter.getClassName());
                List converted = bagConverter.getConvertedObjectIds(profile, className, bagList, extraValue);
                if (converted.size() <= 0) {
                    actionMessages.add("PORTAL_MSG", new ActionMessage("portal.noorthologues", (Object)extraValue, (Object)extId));
                    session.setAttribute("PORTAL_MSG", (Object)actionMessages);
                    return PortalQueryAction.goToResults((ActionMapping)mapping, (HttpSession)session, (WebResults)webResults);
                }
                actionMessages.add("PORTAL_MSG", bagConverter.getActionMessage(extId, converted.size(), className, extraValue));
                session.setAttribute("PORTAL_MSG", (Object)actionMessages);
                if (converted.size() == 1) {
                    return PortalQueryAction.goToReport((ActionMapping)mapping, (String)((Integer)converted.get(0)).toString());
                }
                InterMineBag imBag = profile.createBag(bagName, className, "", (Map)im.getClassKeys());
                return PortalQueryAction.createBagAndGoToBagDetails((ActionMapping)mapping, (InterMineBag)imBag, (List)converted);
            }
        }
        PortalQueryAction.attachMessages((ActionMessages)actionMessages, (String)className, (int)bagQueryResult.getMatches().size(), (int)bagList.size(), (String)extId);
        session.setAttribute("PORTAL_MSG", (Object)actionMessages);
        if (bagList.size() > 1 && idList.length == 1) {
            return PortalQueryAction.goToResults((ActionMapping)mapping, (HttpSession)session, (WebResults)webResults);
        }
        if (bagList.size() == 1 && idList.length == 1) {
            return PortalQueryAction.goToReport((ActionMapping)mapping, (String)((Integer)bagList.get(0)).toString());
        }
        if (goToListUpload) {
            BuildBagForm buildBagForm = null;
            WebJobInput input = new WebJobInput(className, Arrays.asList(idList), buildBagForm);
            input.setExtraValue(extraFieldValue);
            Job job = IDResolver.getInstance().submit(im.getBagQueryRunner(), (JobInput)input);
            session.setAttribute("idresolutionjobid", (Object)job.getUid());
            request.setAttribute("bagType", (Object)className);
            request.setAttribute("bagExtraFilter", (Object)extraFieldValue);
            request.setAttribute("buildNewBag", (Object)"true");
            return mapping.findForward("bagUploadConfirm");
        }
        if (bagList.size() >= 1) {
            InterMineBag imBag = profile.createBag(bagName, className, "", (Map)im.getClassKeys());
            return PortalQueryAction.createBagAndGoToBagDetails((ActionMapping)mapping, (InterMineBag)imBag, bagList);
        }
        return PortalQueryAction.goToResults((ActionMapping)mapping, (HttpSession)session, (WebResults)webResults);
    }

    private static ActionForward goToResults(ActionMapping mapping, HttpSession session, WebResults webResults) {
        SessionMethods.setQuery((HttpSession)session, (PathQuery)webResults.getPathQuery());
        return new ForwardParameters(mapping.findForward("results")).addParameter("trail", "").forward();
    }

    private static ActionForward goToReport(ActionMapping mapping, String id) {
        return new ForwardParameters(mapping.findForward("report")).addParameter("id", id).forward();
    }

    private static ActionForward goToNoResults(ActionMapping mapping) {
        ActionForward forward = mapping.findForward("noResults");
        return new ForwardParameters(forward).addParameter("trail", "").forward();
    }

    private static ActionForward createBagAndGoToBagDetails(ActionMapping mapping, InterMineBag imBag, List<Integer> bagList) throws ObjectStoreException {
        imBag.addIdsToBag(bagList, imBag.getType());
        return new ForwardParameters(mapping.findForward("bagDetails")).addParameter("bagName", imBag.getName()).forward();
    }

    private static void attachMessages(ActionMessages actionMessages, String className, int bagQueryResultSize, int bagListSize, String extId) {
        if (bagListSize == 0 && bagQueryResultSize == 1) {
            ActionMessage msg = new ActionMessage("results.lookup.noresults.one", (Object)new Integer(bagQueryResultSize), (Object)className);
            actionMessages.add("PORTAL_MSG", msg);
        } else if (bagListSize == 0 && bagQueryResultSize > 1) {
            ActionMessage msg = new ActionMessage("results.lookup.noresults.many", (Object)new Integer(bagQueryResultSize), (Object)className);
            actionMessages.add("PORTAL_MSG", msg);
        } else if (bagListSize > 0) {
            ActionMessage msg = new ActionMessage("results.lookup.matches.many", (Object)new Integer(bagListSize));
            actionMessages.add(". PORTAL_MSG", msg);
        } else if (bagListSize == 0) {
            ActionMessage msg = new ActionMessage("portal.nomatches", (Object)extId);
            actionMessages.add("PORTAL_MSG", msg);
        }
    }
}

