/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebResults;
import org.intermine.api.results.WebTable;
import org.intermine.api.template.TemplateHelper;
import org.intermine.api.template.TemplatePopulator;
import org.intermine.model.InterMineObject;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplatePopulatorException;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class ReportTemplateController
extends TilesAction {
    private static final Logger LOG = Logger.getLogger(ReportTemplateController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemplateQuery populatedTemplate;
        InterMineAPI im;
        HttpSession session;
        block5: {
            session = request.getSession();
            im = SessionMethods.getInterMineAPI((HttpSession)session);
            ReportObject reportObject = (ReportObject)context.getAttribute("reportObject");
            InterMineBag interMineBag = (InterMineBag)context.getAttribute("interMineIdBag");
            TemplateQuery template = (TemplateQuery)context.getAttribute("templateQuery");
            try {
                if (reportObject != null) {
                    InterMineObject obj = reportObject.getObject();
                    template = TemplateHelper.removeDirectAttributesFromView((TemplateQuery)template);
                    populatedTemplate = TemplatePopulator.populateTemplateWithObject((TemplateQuery)template, (InterMineObject)obj);
                    break block5;
                }
                if (interMineBag != null) {
                    populatedTemplate = TemplatePopulator.populateTemplateWithBag((TemplateQuery)template, (InterMineBag)interMineBag);
                    break block5;
                }
                return null;
            }
            catch (TemplatePopulatorException e) {
                LOG.error((Object)("Error setting up template '" + template.getName() + "' on report page for" + (reportObject == null ? " bag " + interMineBag.getName() : " object " + reportObject.getId()) + "."), (Throwable)e);
                throw new RuntimeException("Error setting up template '" + template.getName() + "' on report page for" + (reportObject == null ? " bag " + interMineBag.getName() : " object " + reportObject.getId()) + ".", e);
            }
        }
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        WebResultsExecutor executor = im.getWebResultsExecutor(profile);
        WebResults webResults = executor.execute((PathQuery)populatedTemplate);
        if (webResults != null) {
            PagedTable pagedResults = new PagedTable((WebTable)webResults, 20);
            pagedResults.setTableid("itt." + populatedTemplate.getName());
            context.putAttribute("resultsTable", (Object)pagedResults);
        }
        return null;
    }
}

