/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplateSummariser;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.CreateTemplateAction;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;

public class SummariseTemplatesAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(CreateTemplateAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        TemplateSummariser summariser = im.getTemplateSummariser();
        TemplateManager templateManager = new TemplateManager(profile);
        Map templates = templateManager.getGlobalTemplates();
        for (Map.Entry entry : templates.entrySet()) {
            ApiTemplate template = (ApiTemplate)entry.getValue();
            try {
                summariser.summarise(template);
            }
            catch (ObjectStoreException e) {
                this.recordError(new ActionMessage("errors.query.objectstoreerror"), request, (Exception)((Object)e), LOG);
            }
            catch (RuntimeException e) {
                this.recordError(new ActionMessage("errors.query.objectstoreerror"), request, (Exception)e, LOG);
            }
        }
        return new ForwardParameters(mapping.findForward("mymine")).addParameter("subtab", "templates").forward();
    }
}

