/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.TagManager;
import org.intermine.api.search.SearchFilterEngine;
import org.intermine.api.search.SearchRepository;
import org.intermine.api.search.SearchResults;
import org.intermine.api.search.WebSearchable;
import org.intermine.api.template.TemplateManager;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.WebSearchableListController;
import org.stringtree.json.JSONWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebSearchableListController
extends TilesAction {
    private static final Logger LOG = Logger.getLogger(WebSearchableListController.class);
    private InterMineAPI im;
    private static TagManager tagManager;

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String type = (String)context.getAttribute("type");
        String scope = (String)context.getAttribute("scope");
        String tags = (String)context.getAttribute("tags");
        String list = (String)context.getAttribute("list");
        String limit = (String)context.getAttribute("limit");
        String templatesPublicPage = (String)context.getAttribute("templatesPublicPage");
        Map filteredWebSearchables = new HashMap();
        HttpSession session = request.getSession();
        this.im = SessionMethods.getInterMineAPI((HttpSession)session);
        tagManager = this.im.getTagManager();
        if (type.equals("bag") && this.im.getBagManager().isAnyBagToUpgrade(SessionMethods.getProfile((HttpSession)session))) {
            ActionMessages actionErrors = this.getErrors(request);
            actionErrors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("login.upgradeListManually"));
            this.saveErrors(request, actionErrors);
        }
        if (scope.equals("all")) {
            Map globalWebSearchables = WebSearchableListController.getFilterWebSearchables((HttpServletRequest)request, (String)type, (String)"global", (String)tags);
            Map userWebSearchables = WebSearchableListController.getFilterWebSearchables((HttpServletRequest)request, (String)type, (String)"user", (String)tags);
            filteredWebSearchables.putAll(userWebSearchables);
            filteredWebSearchables.putAll(globalWebSearchables);
        } else {
            filteredWebSearchables.putAll(WebSearchableListController.getFilterWebSearchables((HttpServletRequest)request, (String)type, (String)scope, (String)tags));
        }
        if (list != null) {
            filteredWebSearchables = WebSearchableListController.filterByList(filteredWebSearchables, (String)list);
        }
        if (type.equals("bag")) {
            filteredWebSearchables = this.filterByCurrent(filteredWebSearchables);
        }
        int limitInt = 0;
        if (limit != null) {
            try {
                limitInt = new Integer(limit.trim());
            }
            catch (NumberFormatException userWebSearchables) {
                // empty catch block
            }
        }
        filteredWebSearchables = limitInt > 0 ? WebUtil.shuffle(filteredWebSearchables, (int)limitInt) : ("true".equals(templatesPublicPage) ? this.sortListByMostPopular(filteredWebSearchables, session) : this.sortList(filteredWebSearchables));
        HashMap<String, Integer> wsMapForJS = new HashMap<String, Integer>();
        SearchResults.filterOutInvalidTemplates(filteredWebSearchables);
        for (String wsName : filteredWebSearchables.keySet()) {
            wsMapForJS.put(wsName, new Integer(1));
        }
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        request.setAttribute("userWebSearchables", (Object)profile.getWebSearchablesByType(type));
        request.setAttribute("filteredWebSearchables", filteredWebSearchables);
        if (type.equals("bag")) {
            ProfileManager pm = profile.getProfileManager();
            Map sharedBags = profile.getSharedBags();
            HashMap<String, String> sharedBagsByOwner = new HashMap<String, String>();
            for (Map.Entry entry : sharedBags.entrySet()) {
                int id = ((InterMineBag)entry.getValue()).getProfileId();
                Profile owner = pm.getProfile(id);
                sharedBagsByOwner.put((String)entry.getKey(), owner.getName());
            }
            request.setAttribute("sharedBagWebSearchables", sharedBagsByOwner);
        }
        JSONWriter jsonWriter = new JSONWriter();
        request.setAttribute("wsNames", (Object)jsonWriter.write(wsMapForJS));
        return null;
    }

    private Map<String, WebSearchable> sortList(Map<String, WebSearchable> filteredWebSearchables) {
        1 comparator = new /* Unavailable Anonymous Inner Class!! */;
        TreeMap<String, WebSearchable> sortedMap = new TreeMap<String, WebSearchable>((Comparator<String>)comparator);
        sortedMap.putAll(filteredWebSearchables);
        if (filteredWebSearchables.size() != sortedMap.size()) {
            LOG.error((Object)"Important error. Sorting of web searchables removed some items.");
        }
        return sortedMap;
    }

    private Map<String, WebSearchable> sortListByMostPopular(Map<String, WebSearchable> filteredWebSearchables, HttpSession session) {
        TemplateManager tm = this.im.getTemplateManager();
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        List mostPopulareTemplateNames = profile.isLoggedIn() ? tm.getMostPopularTemplateOrder(profile.getUsername(), session.getId(), null) : tm.getMostPopularTemplateOrder(null);
        if (mostPopulareTemplateNames == null) {
            return this.sortList(filteredWebSearchables);
        }
        MostPopularTemplateComparator comparator = new MostPopularTemplateComparator(this, mostPopulareTemplateNames, filteredWebSearchables);
        TreeMap<String, WebSearchable> sortedMap = new TreeMap<String, WebSearchable>((Comparator<String>)comparator);
        sortedMap.putAll(filteredWebSearchables);
        if (filteredWebSearchables.size() != sortedMap.size()) {
            LOG.error((Object)"Important error.Sorting of web searchables by most popular removed some items.");
        }
        return sortedMap;
    }

    public static Map<String, ? extends WebSearchable> getFilterWebSearchables(HttpServletRequest request, String type, String scope, String tags) {
        Map webSearchables;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ServletContext servletContext = session.getServletContext();
        Profile profile = scope.equals("global") ? im.getProfileManager().getSuperuserProfile() : SessionMethods.getProfile((HttpSession)session);
        SearchRepository searchRepository = scope.equals("global") ? SessionMethods.getGlobalSearchRepository((ServletContext)servletContext) : profile.getSearchRepository();
        Map filteredWebSearchables = webSearchables = searchRepository.getWebSearchableMap(type);
        if (tags != null && tags.length() > 0) {
            List<String> tagList = Arrays.asList(StringUtil.split((String)tags.trim(), (String)" "));
            filteredWebSearchables = new SearchFilterEngine().filterByTags(filteredWebSearchables, tagList, type, profile.getUsername(), tagManager, false);
        }
        return filteredWebSearchables;
    }

    public static Map<String, WebSearchable> filterByList(Map<String, WebSearchable> filteredWebSearchables, String list) {
        HashMap<String, WebSearchable> clone = new HashMap<String, WebSearchable>();
        clone.putAll(filteredWebSearchables);
        String tmp = list.replaceAll(" ", "");
        String[] s = tmp.split(",");
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(s));
        for (WebSearchable o : filteredWebSearchables.values()) {
            InterMineBag bag = (InterMineBag)o;
            ObjectStoreBag osb = bag.getOsb();
            Integer i = new Integer(osb.getBagId());
            if (set.contains(i.toString())) continue;
            clone.remove(bag.getName());
        }
        return clone;
    }

    private Map<String, WebSearchable> filterByCurrent(Map<String, WebSearchable> filteredWebSearchables) {
        HashMap<String, WebSearchable> clone = new HashMap<String, WebSearchable>();
        clone.putAll(filteredWebSearchables);
        for (WebSearchable o : filteredWebSearchables.values()) {
            InterMineBag bag = (InterMineBag)o;
            if (bag.isCurrent()) continue;
            clone.remove(bag.getName());
        }
        return clone;
    }

    static /* synthetic */ TagManager access$000() {
        return tagManager;
    }
}

