/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FacetField;
import org.intermine.api.InterMineAPI;
import org.intermine.api.searchengine.KeywordSearchFacet;
import org.intermine.api.searchengine.solr.SolrKeywordSearchHandler;
import org.intermine.webservice.server.FacetService;
import org.intermine.webservice.server.core.JSONService;

public class FacetListService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(FacetService.class);

    public FacetListService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        SolrKeywordSearchHandler searchHandler = new SolrKeywordSearchHandler();
        HashMap facetValues = new HashMap();
        Collection keywordSearchFacets = searchHandler.doFacetSearch(this.im, "*:*", facetValues);
        this.output.setHeaderAttributes(this.getHeaderAttributes());
        HashMap ckData = new HashMap();
        for (KeywordSearchFacet keywordSearchFacet : keywordSearchFacets) {
            ArrayList<String> facetInnerList = new ArrayList<String>();
            for (FacetField.Count count : keywordSearchFacet.getItems()) {
                facetInnerList.add(count.getName());
            }
            ckData.put(keywordSearchFacet.getName(), facetInnerList);
        }
        this.addResultItem(ckData, false);
    }

    protected String getResultsKey() {
        return "facet-list";
    }
}

