/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.text.MessageFormat;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.util.MailUtils;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ServiceException;

public class FeedbackService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(FeedbackService.class);

    public FeedbackService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        String from = this.getOptionalParameter("email");
        String feedback = this.getRequiredParameter("feedback");
        String destination = this.webProperties.getProperty("feedback.destination");
        String body = null;
        if (from != null) {
            String feedbackMailText = "Email: {0}\n\n{1}";
            body = MessageFormat.format(feedbackMailText, from, feedback);
        } else {
            body = feedback;
        }
        try {
            MailUtils.email((String)destination, (String)"Feedback", (String)body, (String)from, (Properties)this.webProperties);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage());
            throw new ServiceException("Error sending feedback.");
        }
    }
}

