/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.StringUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.SchemaListService;

public class SchemaServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(SchemaServlet.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.runService(request, response);
    }

    private void runService(HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isEmpty((String)request.getPathInfo())) {
            this.serveSchemaList(request, response);
        } else {
            this.serveSpecificSchema(request, response);
        }
    }

    private void serveSpecificSchema(HttpServletRequest req, HttpServletResponse resp) {
        String fileName = StringUtil.trimSlashes((String)req.getPathInfo());
        Properties webProperties = InterMineContext.getWebProperties();
        HashSet<String> schemata = new HashSet<String>(Arrays.asList(webProperties.getProperty("schema.filenames", "").split(",")));
        if (!schemata.contains(fileName)) {
            resp.setStatus(404);
            try {
                PrintWriter pw = resp.getWriter();
                pw.println(fileName + " is not in the list of schemata.");
                pw.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Could not write response", (Throwable)e);
            }
        } else {
            try {
                ResponseUtil.setFileName((HttpServletResponse)resp, (String)fileName);
                if (fileName.endsWith("schema")) {
                    ResponseUtil.setJSONSchemaContentType((HttpServletResponse)resp);
                } else if (fileName.endsWith("xsd")) {
                    ResponseUtil.setXMLContentType((HttpServletResponse)resp);
                }
                InputStream in = this.getServletContext().getResourceAsStream("/webservice/" + fileName);
                PrintWriter out = resp.getWriter();
                IOUtils.copy((InputStream)in, (Writer)out, (String)"UTF-8");
            }
            catch (Throwable t) {
                LOGGER.error((Object)t);
                resp.setStatus(500);
                try {
                    resp.getWriter().println("Could not serve " + fileName + ": " + t.getMessage());
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
    }

    private void serveSchemaList(HttpServletRequest req, HttpServletResponse resp) {
        InterMineAPI im = InterMineContext.getInterMineAPI();
        new SchemaListService(im).service(req, resp);
    }
}

