/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.intermine.webservice.server.core.Predicate;

public class RateLimitHistory
implements Predicate<String> {
    private final Map<String, List<Long>> historyOfRequests = new HashMap();
    private int periodLength;
    private int maxRequests;

    public RateLimitHistory(int periodInSeconds, int maxRequestsPerPeriod) {
        this.periodLength = periodInSeconds;
        this.maxRequests = maxRequestsPerPeriod;
    }

    private synchronized List<Long> getRequestHistory(String id) {
        List<Long> requestHistory = new ArrayList<Long>();
        if (id != null) {
            if (this.historyOfRequests.containsKey(id)) {
                requestHistory = (List)this.historyOfRequests.get(id);
                Iterator<Long> it = requestHistory.iterator();
                while (it.hasNext()) {
                    Long timestamp = it.next();
                    if (timestamp != null && System.currentTimeMillis() - timestamp <= (long)(this.periodLength * 1000)) continue;
                    it.remove();
                }
            } else {
                this.historyOfRequests.put(id, requestHistory);
            }
        }
        return requestHistory;
    }

    public synchronized boolean isWithinLimit(String id) {
        List requests = this.getRequestHistory(id);
        return requests.size() < this.maxRequests;
    }

    public Boolean call(String id) {
        return this.isWithinLimit(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordRequest(String id) {
        List requests;
        List list = requests = this.getRequestHistory(id);
        synchronized (list) {
            requests.add(System.currentTimeMillis());
        }
    }
}

