/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.exceptions;

public class ServiceException
extends RuntimeException {
    private final int httpErrorCode;
    private static final long serialVersionUID = 1L;

    public ServiceException(String message) {
        super(message);
        this.httpErrorCode = 500;
    }

    public ServiceException(String message, int code) {
        super(message);
        this.httpErrorCode = code;
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.httpErrorCode = 500;
    }

    public ServiceException(String message, Throwable cause, int code) {
        super(message, cause);
        this.httpErrorCode = code;
    }

    public ServiceException(Throwable cause) {
        super(cause);
        this.httpErrorCode = 500;
    }

    public ServiceException(Throwable cause, int code) {
        super(cause);
        this.httpErrorCode = code;
    }

    @Override
    public String getMessage() {
        if (super.getMessage() == null || super.getMessage().length() == 0) {
            return "Error code: " + this.getHttpErrorCode();
        }
        return super.getMessage();
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }
}

