/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.lists.AuthenticatedListService;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.lists.ListServiceUtils;

public abstract class ListMakerService
extends AuthenticatedListService {
    protected static final String LIST_TYPE_KEY = "type";

    public ListMakerService(InterMineAPI api) {
        super(api);
    }

    protected void validateState() {
        super.validateState();
        if (!this.getPermission().isRW()) {
            throw new ServiceForbiddenException("This request has not been authenticated with RW permission");
        }
    }

    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(super.getHeaderAttributes());
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"listSize\":");
        }
        return attributes;
    }

    protected Format getDefaultFormat() {
        return Format.JSON;
    }

    protected boolean canServe(Format format) {
        return format == Format.JSON || format == Format.TEXT;
    }

    protected void initialiseDelendumAccumulator(Set<String> accumulator, ListInput input) {
        accumulator.add(input.getTemporaryListName());
    }

    protected abstract String getNewListType(ListInput var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        ListInput input = this.getInput();
        this.addOutputInfo("listName", input.getListName());
        String type = this.getNewListType(input);
        if (type != null) {
            this.addOutputInfo(LIST_TYPE_KEY, type);
        }
        HashSet rubbishbin = new HashSet();
        this.initialiseDelendumAccumulator(rubbishbin, input);
        try {
            this.makeList(input, type, profile, rubbishbin);
        }
        finally {
            for (String delendum : rubbishbin) {
                ListServiceUtils.ensureBagIsDeleted((Profile)profile, (String)delendum);
            }
        }
    }

    protected abstract void makeList(ListInput var1, String var2, Profile var3, Set<String> var4) throws Exception;
}

