/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.operations.BagOperation;
import org.intermine.api.bag.operations.IncompatibleTypes;
import org.intermine.api.bag.operations.NoContent;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.lists.CommutativeOperationInput;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.lists.ListMakerService;
import org.intermine.webservice.server.lists.ListServiceUtils;

public abstract class ListOperationService
extends ListMakerService {
    public ListOperationService(InterMineAPI api) {
        super(api);
    }

    public String getNewListType(ListInput input) {
        return null;
    }

    protected ListInput getInput() {
        return new CommutativeOperationInput(this.request, this.bagManager, this.getPermission().getProfile());
    }

    protected abstract BagOperation getOperation(ListInput var1);

    protected void makeList(ListInput input, String type, Profile profile, Set<String> rubbishbin) throws Exception {
        InterMineBag newBag;
        int size = 0;
        BagOperation operation = this.getOperation(input);
        operation.setClassKeys((Map)this.im.getClassKeys());
        try {
            rubbishbin.add(operation.getNewBagName());
        }
        catch (IncompatibleTypes e) {
            throw new BadRequestException("Incompatible types", (Throwable)e);
        }
        try {
            if (type == null) {
                this.addOutputInfo("type", operation.getNewBagType());
            }
            newBag = operation.operate();
            size = newBag.getSize();
        }
        catch (NoContent e) {
            size = 0;
            newBag = profile.createBag(operation.getNewBagName(), operation.getNewBagType(), input.getDescription(), (Map)this.im.getClassKeys());
        }
        this.addOutputInfo("listId", newBag.getSavedBagId().toString());
        if (input.getDescription() != null) {
            newBag.setDescription(input.getDescription());
        }
        if (!input.getTags().isEmpty()) {
            this.bagManager.addTagsToBag((Collection)input.getTags(), newBag, profile);
        }
        this.output.addResultItem(Arrays.asList("" + size));
        if (input.doReplace()) {
            ListServiceUtils.ensureBagIsDeleted((Profile)profile, (String)input.getListName());
        }
        profile.renameBag(newBag.getName(), input.getListName());
    }
}

