/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.SharedBagManager;
import org.intermine.api.bag.SharingInvite;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.UserAlreadyShareBagException;
import org.intermine.api.profile.UserNotFoundException;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.lists.JSONListFormatter;
import org.intermine.webservice.server.lists.ListSharingInvitationAcceptanceService;

public class ListSharingInvitationAcceptanceService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(ListSharingInvitationAcceptanceService.class);
    private static final Set<String> ACCEPTABLE_ACCEPTANCES = new HashSet<String>(Arrays.asList("true", "false"));
    private final SharedBagManager sbm;

    public ListSharingInvitationAcceptanceService(InterMineAPI im) {
        super(im);
        this.sbm = SharedBagManager.getInstance((ProfileManager)im.getProfileManager());
    }

    protected String getResultsKey() {
        return "list";
    }

    protected void execute() throws SharingInvite.NotFoundException {
        UserInput input = new UserInput(this);
        try {
            this.sbm.resolveInvitation(input.invite, input.accepter, input.accepted);
        }
        catch (UserNotFoundException e) {
            throw new ServiceException("Inconsistent state: p.isLoggedIn() but not found in DB");
        }
        catch (UserAlreadyShareBagException e) {
            LOG.warn((Object)"User accepted an invitation to a list they already have access to", (Throwable)e);
        }
        if (input.notify) {
            this.notifyOwner(input.invite);
        }
        if (input.accepted) {
            JSONListFormatter formatter = new JSONListFormatter(this.im, input.accepter, false);
            this.addResultItem(formatter.bagToMap(input.invite.getBag()), false);
        } else {
            this.addResultItem(new HashMap(), false);
        }
    }

    private void notifyOwner(SharingInvite invite) {
        ProfileManager pm = this.im.getProfileManager();
        Profile receiver = this.getPermission().getProfile();
        Profile owner = pm.getProfile(invite.getBag().getProfileId().intValue());
        boolean queued = InterMineContext.queueMessage((MailAction)new /* Unavailable Anonymous Inner Class!! */);
        if (!queued) {
            LOG.error((Object)"Mail queue full, could not send message");
        }
    }

    static /* synthetic */ ProfileManager.ApiPermission access$000(ListSharingInvitationAcceptanceService x0) {
        return x0.getPermission();
    }

    static /* synthetic */ HttpServletRequest access$100(ListSharingInvitationAcceptanceService x0) {
        return x0.request;
    }

    static /* synthetic */ HttpServletRequest access$200(ListSharingInvitationAcceptanceService x0) {
        return x0.request;
    }

    static /* synthetic */ HttpServletRequest access$300(ListSharingInvitationAcceptanceService x0) {
        return x0.request;
    }

    static /* synthetic */ Set access$400() {
        return ACCEPTABLE_ACCEPTANCES;
    }

    static /* synthetic */ InterMineAPI access$500(ListSharingInvitationAcceptanceService x0) {
        return x0.im;
    }

    static /* synthetic */ HttpServletRequest access$600(ListSharingInvitationAcceptanceService x0) {
        return x0.request;
    }

    static /* synthetic */ Properties access$700(ListSharingInvitationAcceptanceService x0) {
        return x0.webProperties;
    }
}

