/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.oauth2;

import org.apache.log4j.Logger;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.intermine.api.InterMineAPI;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class AuthenticatorService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(AuthenticatorService.class);

    public AuthenticatorService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        String providerName = this.getRequiredParameter("provider");
        String realm = this.webProperties.getProperty("webapp.baseurl");
        String authorisationUrl = this.webProperties.getProperty("oauth2." + providerName + ".url.auth");
        if (authorisationUrl == null) {
            try {
                OAuthProviderType providerType = OAuthProviderType.valueOf((String)providerName);
                authorisationUrl = providerType.getAuthzEndpoint();
            }
            catch (IllegalArgumentException ex) {
                throw new BadRequestException("Provider name " + providerName + " unknown");
            }
        }
        OAuthClientRequest authRequest = OAuthClientRequest.authorizationLocation((String)authorisationUrl).setClientId(this.webProperties.getProperty("oauth2." + providerName + ".client-id")).setScope(this.webProperties.getProperty("oauth2." + providerName + ".scopes")).setParameter("response_type", "code").setParameter("openid.realm", realm).buildQueryMessage();
        String link = authRequest.getLocationUri();
        this.addResultEntry("link", (Object)link, false);
    }
}

