/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.webservice.server.output.Formatter;
import org.json.JSONObject;

public class JSONFormatter
extends Formatter {
    private boolean hasCallback = false;
    private String outro = "";
    private boolean shouldQuote = false;
    private boolean hasPrintedSomething = false;
    private boolean isExpectingPrimitive = false;
    private String header = null;
    public static final String KEY_CALLBACK = "callback";
    public static final String KEY_INTRO = "intro";
    public static final String KEY_OUTRO = "outro";
    public static final String KEY_QUOTE = "should_quote";
    public static final String KEY_HEADER_OBJS = "headerObjs";
    public static final String KEY_KV_PAIRS = "key_value_pairs";
    public static final String KEY_TIME = "executionTime";
    public static final Set<String> RESERVED_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("callback", "intro", "outro", "should_quote", "headerObjs", "key_value_pairs", "executionTime")));

    public String formatHeader(Map<String, Object> attributes) {
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        StringBuilder sb = new StringBuilder();
        Object callback = attributes.get(KEY_CALLBACK);
        if (callback != null) {
            this.hasCallback = true;
            sb.append(callback).append("(");
        }
        sb.append("{");
        this.formatAttributes(attributes, sb);
        this.header = sb.toString();
        return this.header;
    }

    protected void formatAttributes(Map<String, Object> attributes, StringBuilder sb) {
        if (attributes == null) {
            return;
        }
        if (sb == null) {
            throw new NullPointerException("sb must not be null");
        }
        if (attributes.containsKey(KEY_KV_PAIRS)) {
            Map kvPairs = (Map)attributes.get(KEY_KV_PAIRS);
            for (Map.Entry pair : kvPairs.entrySet()) {
                sb.append("\"").append(StringEscapeUtils.escapeJava((String)((String)pair.getKey()))).append("\":").append(this.quoteValue(StringEscapeUtils.escapeJava((String)((String)pair.getValue())))).append(",");
            }
        }
        if (attributes.containsKey(KEY_HEADER_OBJS)) {
            Map headerObjs = (Map)attributes.get(KEY_HEADER_OBJS);
            for (Map.Entry pair : headerObjs.entrySet()) {
                sb.append("\"").append(StringEscapeUtils.escapeJava((String)((String)pair.getKey()))).append("\":").append(new JSONObject((Map)pair.getValue())).append(",");
            }
        }
        if (attributes.get(KEY_INTRO) != null) {
            sb.append(attributes.get(KEY_INTRO));
            if (attributes.containsKey(KEY_OUTRO)) {
                this.outro = attributes.get(KEY_OUTRO).toString();
            } else {
                this.isExpectingPrimitive = true;
            }
        }
        if (attributes.containsKey(KEY_QUOTE)) {
            this.shouldQuote = (Boolean)attributes.get(KEY_QUOTE);
        }
    }

    private String quoteValue(String val) {
        if (val == null) {
            return "null";
        }
        if (StringUtils.isEmpty((String)val)) {
            return "\"" + val + "\"";
        }
        if ("null".equals(val) || "true".equals(val) || "false".equals(val) || StringUtils.isNumeric((String)val)) {
            return val;
        }
        return "\"" + val + "\"";
    }

    public String formatResult(List<String> resultRow) {
        if (resultRow.isEmpty()) {
            return "";
        }
        Iterator<String> iter = resultRow.iterator();
        String first = iter.next();
        if (this.shouldQuote && !"".equals(first)) {
            first = this.quoteValue(first);
        }
        StringBuffer buffer = new StringBuffer(first == null ? "null" : first);
        while (iter.hasNext()) {
            String next = iter.next();
            if (this.shouldQuote && !"".equals(next)) {
                next = this.quoteValue(next);
            }
            buffer.append(",").append(next);
        }
        this.declarePrinted();
        return buffer.toString();
    }

    protected void declarePrinted() {
        this.hasPrintedSomething = true;
    }

    public String formatFooter(String errorMessage, int errorCode) {
        StringBuilder sb = new StringBuilder(this.outro);
        if (!this.hasPrintedSomething && this.isExpectingPrimitive) {
            sb.append("null");
        }
        if (this.header == null || this.hasPrintedSomething || !this.header.endsWith("{") && !this.header.endsWith(",")) {
            sb.append(',');
        }
        Date now = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm::ss");
        String executionTime = dateFormatter.format(now);
        sb.append("\"executionTime\":\"" + executionTime + "\",");
        sb.append("\"wasSuccessful\":");
        if (errorCode >= 400) {
            sb.append("false,\"error\":\"" + StringEscapeUtils.escapeJava((String)errorMessage) + "\"");
        } else {
            sb.append("true,\"error\":null");
        }
        sb.append(",\"statusCode\":" + errorCode);
        sb.append("}");
        if (this.hasCallback) {
            sb.append(");");
        }
        return sb.toString();
    }
}

