/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.pathquery.ConstraintValueParser;
import org.intermine.pathquery.Path;
import org.intermine.webservice.server.output.JSONFormattingException;
import org.json.JSONObject;

public class JSONResultsIterator
implements Iterator<JSONObject> {
    private static final String CLASS_KEY = "class";
    private static final String ID_KEY = "objectId";
    private static final String ID_FIELD = "id";
    private final ExportResultsIterator subIter;
    private List<ResultElement> holdOver;
    private final List<Path> viewPaths = new ArrayList();
    protected transient Map<String, Object> currentMap;
    protected transient List<Map<String, Object>> currentArray;
    private Model model;

    public JSONResultsIterator(ExportResultsIterator it) {
        this.subIter = it;
        this.init();
    }

    private void init() {
        this.model = this.subIter.getQuery().getModel();
        this.viewPaths.addAll(this.subIter.getViewPaths());
    }

    @Override
    public boolean hasNext() {
        return this.subIter.hasNext() || this.holdOver != null;
    }

    @Override
    public JSONObject next() {
        HashMap nextJsonMap = new HashMap();
        Integer lastId = null;
        if (this.holdOver != null) {
            lastId = ((ResultElement)this.holdOver.get(0)).getId();
            this.addRowToJsonMap(this.holdOver, nextJsonMap);
            this.holdOver = null;
        }
        while (this.subIter.hasNext()) {
            List result = this.subIter.next();
            for (ResultElement cell : result) {
                if (cell == null || cell.getId() != null) continue;
                cell.setSimpleCellId();
            }
            Integer currentId = ((ResultElement)result.get(0)).getId();
            if (lastId != null && !lastId.equals(currentId)) {
                this.holdOver = result;
                lastId = currentId;
                break;
            }
            this.addRowToJsonMap(result, nextJsonMap);
            lastId = currentId;
        }
        JSONObject nextObj = new JSONObject(nextJsonMap);
        return nextObj;
    }

    private void addRowToJsonMap(List<ResultElement> results, Map<String, Object> jsonMap) {
        this.setOrCheckClassAndId(results.get(0), (Path)this.viewPaths.get(0), jsonMap);
        for (int i = 0; i < results.size(); ++i) {
            ResultElement cell = results.get(i);
            if (cell == null || cell.getType() == null) continue;
            Path columnPath = (Path)this.viewPaths.get(i);
            this.addCellToJsonMap(cell, columnPath, jsonMap);
        }
    }

    protected boolean isCellValidForPath(ResultElement cell, Path path) {
        if (cell == null || cell.getType() == null) {
            return true;
        }
        return this.aIsaB(cell.getType(), path.getLastClassDescriptor().getName());
    }

    protected boolean aIsaB(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        ClassDescriptor aCls = this.model.getClassDescriptorByName(a);
        ClassDescriptor bCls = this.model.getClassDescriptorByName(b);
        if (aCls == null || bCls == null) {
            throw new IllegalArgumentException("These names are not valid classes: a=" + a + ",b=" + b);
        }
        if (aCls.equals((Object)bCls)) {
            return true;
        }
        return this.aDescendsFromB(aCls.getName(), bCls.getName());
    }

    protected boolean aDescendsFromB(String a, String b) {
        Set supers;
        try {
            supers = ClassDescriptor.findSuperClassNames((Model)this.model, (String)a);
        }
        catch (MetaDataException e) {
            throw new JSONFormattingException("Problem getting supers for " + a, (Throwable)e);
        }
        return supers.contains(b);
    }

    protected void setOrCheckClassAndId(ResultElement cell, Path path, Map<String, Object> jsonMap) {
        this.setOrCheckClass(cell, path, jsonMap);
        this.setOrCheckId(cell, jsonMap);
    }

    protected void setOrCheckClass(ResultElement cell, Path path, Map<String, Object> jsonMap) {
        String thisType = path.getLastClassDescriptor().getUnqualifiedName();
        if (jsonMap.containsKey(CLASS_KEY)) {
            String storedType = (String)jsonMap.get(CLASS_KEY);
            if (!this.aIsaB(cell.getType(), storedType)) {
                throw new JSONFormattingException("This result element (" + cell + ") does not belong on this map (" + jsonMap + ") - classes don't match (" + cell.getType() + " ! isa " + jsonMap.get(CLASS_KEY) + ")");
            }
        }
        if (!this.isCellValidForPath(cell, path)) {
            throw new JSONFormattingException("This result element (" + cell + ") does not match its column because: classes not compatible (" + thisType + " is not a superclass of " + cell.getType() + ")");
        }
        jsonMap.put(CLASS_KEY, cell.getType());
    }

    protected void setOrCheckId(ResultElement cell, Map<String, Object> jsonMap) {
        Integer cellId = cell.getId();
        if (jsonMap.containsKey(ID_KEY)) {
            Object mapId = jsonMap.get(ID_KEY);
            if (cellId != null && mapId != null && !jsonMap.get(ID_KEY).equals(cell.getId())) {
                throw new JSONFormattingException("This result element (" + cell + ") does not belong on this map (" + jsonMap + ") - objectIds don't match (" + jsonMap.get(ID_KEY) + " != " + cell.getId() + ")");
            }
        } else {
            jsonMap.put(ID_KEY, cell.getId());
        }
    }

    private void addCellToJsonMap(ResultElement cell, Path column, Map<String, Object> rootMap) {
        if (column.isOnlyAttribute()) {
            this.addFieldToMap(cell, column, rootMap);
        } else {
            this.addReferencedCellToJsonMap(cell, column, rootMap);
        }
    }

    protected void addFieldToMap(ResultElement cell, Path column, Map<String, Object> objectMap) {
        this.setOrCheckClassAndId(cell, column, objectMap);
        String key = column.getLastElement();
        if (ID_FIELD.equals(key)) {
            return;
        }
        Object newValue = cell.getField() instanceof Date ? ConstraintValueParser.ISO_DATE_FORMAT.format(cell.getField()) : (cell.getField() instanceof ClobAccess ? cell.getField().toString() : (cell.getField() == null ? JSONObject.NULL : cell.getField()));
        if (newValue instanceof CharSequence) {
            newValue = newValue.toString();
        }
        if (objectMap.containsKey(key)) {
            Object current = objectMap.get(key);
            if (current == null ? newValue != null : !current.equals(newValue)) {
                throw new JSONFormattingException("Trying to set key " + key + " as " + newValue + " in " + objectMap + " but it already has the value " + current);
            }
        } else {
            objectMap.put(key, newValue);
        }
    }

    protected void addReferencedCellToJsonMap(ResultElement cell, Path column, Map<String, Object> objectMap) {
        this.currentMap = objectMap;
        List columnSections = column.decomposePath();
        for (Path section : columnSections) {
            if (section.isRootPath()) continue;
            if (section.endIsAttribute()) {
                this.addAttributeToCurrentNode(section, cell);
                continue;
            }
            if (section.endIsReference()) {
                this.addReferenceToCurrentNode(section);
                continue;
            }
            if (section.endIsCollection()) {
                this.addCollectionToCurrentNode(section);
                continue;
            }
            throw new JSONFormattingException("Bad path type: " + section.toString());
        }
    }

    protected void setCurrentMapFromCurrentArray(ResultElement cell) {
        if (this.currentArray == null) {
            throw new JSONFormattingException("Nowhere to put this field");
        }
        boolean foundMap = false;
        for (Map obj : this.currentArray) {
            if (obj == null) {
                throw new JSONFormattingException("null map found in current array");
            }
            if (cell == null) {
                throw new JSONFormattingException("trying to add null cell to current array");
            }
            foundMap = cell.getId() == null ? obj.get(ID_KEY) == null : obj.get(ID_KEY).equals(cell.getId());
            if (!foundMap) continue;
            this.currentMap = obj;
            break;
        }
        if (!foundMap) {
            HashMap newMap = new HashMap();
            this.currentArray.add(newMap);
            this.currentMap = newMap;
        }
        this.currentArray = null;
    }

    protected void setCurrentMapFromCurrentArray() {
        try {
            this.currentMap = (Map)this.currentArray.get(this.currentArray.size() - 1);
        }
        catch (NullPointerException e) {
            throw new JSONFormattingException("Nowhere to put this reference - the current array is null", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONFormattingException("This array is empty - is the view in the wrong order?", (Throwable)e);
        }
        this.currentArray = null;
    }

    private void addAttributeToCurrentNode(Path attributePath, ResultElement cell) {
        if (this.currentMap == null) {
            try {
                this.setCurrentMapFromCurrentArray(cell);
            }
            catch (JSONFormattingException e) {
                throw new JSONFormattingException("While adding processing " + attributePath, (Throwable)e);
            }
        }
        this.addFieldToMap(cell, attributePath, this.currentMap);
    }

    protected void addReferenceToCurrentNode(Path referencePath) {
        String key;
        if (this.currentMap == null) {
            this.setCurrentMapFromCurrentArray();
        }
        if (this.currentMap.containsKey(key = referencePath.getLastElement())) {
            Object storedItem = this.currentMap.get(key);
            boolean storedItemIsMap = storedItem instanceof Map;
            if (!storedItemIsMap) {
                throw new JSONFormattingException("Trying to set a reference on " + key + ", but this node " + this.currentMap + " already has this key set, and to something other than a map (" + storedItem.getClass().getName() + ": " + storedItem + ")");
            }
            Map foundMap = (Map)this.currentMap.get(key);
            if (!foundMap.containsKey(ID_KEY)) {
                throw new JSONFormattingException("This node is not fully initialised: it has no objectId");
            }
            this.currentMap = foundMap;
        } else {
            HashMap<String, String> newMap = new HashMap<String, String>();
            ReferenceDescriptor refDesc = (ReferenceDescriptor)referencePath.getEndFieldDescriptor();
            newMap.put(CLASS_KEY, refDesc.getReferencedClassDescriptor().getUnqualifiedName());
            this.currentMap.put(key, newMap);
            this.currentMap = newMap;
        }
    }

    protected void addCollectionToCurrentNode(Path collectionPath) {
        if (this.currentMap == null) {
            this.setCurrentMapFromCurrentArray();
        }
        String key = collectionPath.getLastElement();
        if (!this.currentMap.containsKey(ID_KEY)) {
            throw new JSONFormattingException("This node is not properly initialised (it doesn't have an objectId) - is the view in the right order?");
        }
        if (this.currentMap.containsKey(key)) {
            Object storedValue = this.currentMap.get(key);
            if (!(storedValue instanceof List)) {
                throw new JSONFormattingException("Trying to set a collection on " + key + ", but this node " + this.currentMap + " already has this key set to something other than a list (" + storedValue.getClass().getName() + ": " + storedValue + ")");
            }
        } else {
            ArrayList newArray = new ArrayList();
            this.currentMap.put(key, newArray);
        }
        this.currentArray = (List)this.currentMap.get(key);
        this.currentMap = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not implemented in this class");
    }
}

