/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.query.QueryStore;
import org.intermine.api.query.QueryStoreException;
import org.intermine.webservice.server.WebServiceRequestParser;
import org.intermine.webservice.server.exceptions.BadRequestException;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryRequestParser
extends WebServiceRequestParser {
    protected HttpServletRequest request;
    private QueryStore queryStore;
    private static final String QUERY_PARAMETER = "query";
    private static final String QLZW_PARAMETER = "qlzw";
    private static final String QID = "qid";

    public QueryRequestParser(QueryStore queryStore, HttpServletRequest request) {
        this.queryStore = queryStore;
        this.request = request;
    }

    private static String fixEncoding(String latin1) {
        try {
            byte[] bytes = latin1.getBytes("ISO-8859-1");
            if (!QueryRequestParser.validUTF8((byte[])bytes)) {
                return latin1;
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Neither Latin1 nor UTF-8: " + e.getMessage());
        }
    }

    private static boolean validUTF8(byte[] input) {
        int i = 0;
        if (input.length >= 3 && (input[0] & 0xFF) == 239 && (input[1] & 0xFF) == 187 & (input[2] & 0xFF) == 191) {
            i = 3;
        }
        int j = input.length;
        while (i < j) {
            byte octet = input[i];
            if ((octet & 0x80) != 0) {
                int end;
                if ((octet & 0xE0) == 192) {
                    end = i + 1;
                } else if ((octet & 0xF0) == 224) {
                    end = i + 2;
                } else if ((octet & 0xF8) == 240) {
                    end = i + 3;
                } else {
                    return false;
                }
                while (i < end) {
                    if (((octet = input[++i]) & 0xC0) == 128) continue;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static String decompressLZW(List<Integer> compressed) {
        String w;
        int dictSize = 256;
        HashMap<Integer, String> dictionary = new HashMap<Integer, String>();
        for (int i = 0; i < 256; ++i) {
            dictionary.put(i, "" + (char)i);
        }
        String result = w = "" + (char)compressed.remove(0).intValue();
        for (int k : compressed) {
            String entry;
            if (dictionary.containsKey(k)) {
                entry = (String)dictionary.get(k);
            } else if (k == dictSize) {
                entry = w + w.charAt(0);
            } else {
                throw new IllegalArgumentException("Bad compressed k: " + k);
            }
            result = result + entry;
            dictionary.put(dictSize++, w + entry.charAt(0));
            w = entry;
        }
        return result;
    }

    public static String decodeLZWString(String encoded) {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        encoded = QueryRequestParser.fixEncoding((String)encoded);
        int length = encoded.length();
        for (int i = 0; i < length; ++i) {
            Integer cp = encoded.codePointAt(i);
            codes.add(cp);
        }
        return QueryRequestParser.decompressLZW(codes);
    }

    public String getQueryXml() {
        String qid = this.request.getParameter("qid");
        String xmlQuery = this.request.getParameter("query");
        String lzwQuery = this.request.getParameter("qlzw");
        if (StringUtils.isNotBlank((String)qid)) {
            try {
                return this.queryStore.getQuery(qid);
            }
            catch (QueryStoreException e) {
                throw new BadRequestException(e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((String)lzwQuery)) {
            xmlQuery = QueryRequestParser.decodeLZWString((String)lzwQuery);
        }
        if (StringUtils.isBlank((String)xmlQuery)) {
            throw new BadRequestException("The 'query' parameter must not be blank");
        }
        return QueryRequestParser.fixEncoding((String)xmlQuery);
    }
}

