/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.template.SingleTemplateService;

public class SingleTemplateService
extends JSONService {
    public SingleTemplateService(InterMineAPI im) {
        super(im);
    }

    protected boolean canServe(Format format) {
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[format.ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"template.xml");
        return new StreamedOutput(out, (Formatter)new PlainFormatter(), separator);
    }

    protected void execute() {
        String name = StringUtils.defaultString((String)this.request.getPathInfo(), (String)"");
        if (StringUtils.isBlank((String)(name = name.replaceAll("^/", "")))) {
            throw new BadRequestException("No name provided");
        }
        Profile p = this.getPermission().getProfile();
        TemplateManager tm = this.im.getTemplateManager();
        ApiTemplate t = tm.getUserOrGlobalTemplate(p, name);
        if (t == null) {
            throw new ResourceNotFoundException("No template found called " + name);
        }
        if (Format.JSON == this.getFormat()) {
            this.output.addResultItem(Arrays.asList(t.toJSON()));
        } else {
            ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)(name + ".xml"));
            this.output.addResultItem(Arrays.asList(t.toXml()));
        }
    }

    public String getResultsKey() {
        return "template";
    }
}

