/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.template.TemplateQuery;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.template.TemplatePrecomputeService;

public class TemplatePrecomputeService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(TemplatePrecomputeService.class);

    public TemplatePrecomputeService(InterMineAPI im) {
        super(im);
    }

    protected void validateState() {
        if (!this.isAuthenticated() || !this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("This request is not authenticated.");
        }
    }

    protected boolean canServe(Format format) {
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[format.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected void execute() throws Exception {
        String templateName = this.getRequiredParameter("name");
        Profile currentProfile = this.getPermission().getProfile();
        Map templates = currentProfile.getSavedTemplates();
        TemplateQuery template = (TemplateQuery)templates.get(templateName);
        HashMap<String, Boolean> precomputedTemplateMap = new HashMap<String, Boolean>();
        if (template == null) {
            throw new BadRequestException("The template " + templateName + " doesn't exist");
        }
        if (!template.isValid()) {
            throw new BadRequestException("The template " + templateName + " is not valid");
        }
        WebResultsExecutor executor = this.im.getWebResultsExecutor(currentProfile);
        try {
            executor.precomputeTemplate(template);
            precomputedTemplateMap.put(templateName, true);
        }
        catch (ObjectStoreException e) {
            LOG.error((Object)"Error while precomputing", (Throwable)e);
            precomputedTemplateMap.put(templateName, false);
        }
        this.addResultItem(precomputedTemplateMap, false);
    }

    public String getResultsKey() {
        return "templates";
    }
}

