/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.ReadWriteJSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.template.TemplateRemovalService;

public class TemplateRemovalService
extends ReadWriteJSONService {
    public TemplateRemovalService(InterMineAPI im) {
        super(im);
    }

    protected boolean canServe(Format format) {
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[format.ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected void validateState() {
        if (this.getPermission().getLevel() == ProfileManager.ApiPermission.Level.RO) {
            throw new ServiceForbiddenException("Access denied.");
        }
    }

    protected void execute() throws Exception {
        String name = StringUtils.defaultString((String)this.request.getPathInfo(), (String)"");
        if (StringUtils.isBlank((String)(name = name.replaceAll("^/", "")))) {
            throw new BadRequestException("No name provided");
        }
        Profile p = this.getPermission().getProfile();
        if (!p.getSavedTemplates().containsKey(name)) {
            throw new ResourceNotFoundException("No template called " + name);
        }
        p.deleteTemplate(name, this.im.getTrackerDelegate(), true);
    }
}

