/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.UnauthorizedException;

public class ChangePasswordService
extends JSONService {
    public ChangePasswordService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        String oldPassword = this.getRequiredParameter("oldPassword");
        String newPassword = this.getRequiredParameter("newPassword");
        ProfileManager pm = this.im.getProfileManager();
        if (!this.isAuthenticated()) {
            throw new UnauthorizedException("The request must be authenticated");
        }
        Profile profile = this.getPermission().getProfile();
        if (!pm.validPassword(profile.getUsername(), oldPassword)) {
            throw new ServiceException("Old password wrong", 403);
        }
        pm.setPassword(profile.getUsername(), newPassword);
    }
}

