/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.UnauthorizedException;
import org.intermine.webservice.server.user.JSONUserFormatter;
import org.json.JSONObject;

public class LoginService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(LoginService.class);

    public LoginService(InterMineAPI im) {
        super(im);
    }

    protected String getResultsKey() {
        return "output";
    }

    protected void execute() throws Exception {
        String username = this.getRequiredParameter("username");
        String password = this.getRequiredParameter("password");
        Profile currentProfile = this.getPermission().getProfile();
        Profile profile = null;
        try {
            profile = this.getUser(username, password);
        }
        catch (ProfileManager.AuthenticationException ex) {
            throw new UnauthorizedException(ex.getMessage());
        }
        HashMap<String, Object> output = new HashMap<String, Object>();
        JSONUserFormatter formatter = new JSONUserFormatter(profile);
        output.put("user", new JSONObject(formatter.format()));
        output.put("token", this.im.getProfileManager().generate24hrKey(profile));
        ProfileMergeIssues issues = null;
        if (currentProfile != null && StringUtils.isEmpty((String)currentProfile.getUsername())) {
            issues = LoginHandler.mergeProfiles((Profile)currentProfile, (Profile)profile);
            output.put("renamedLists", new JSONObject(issues.getRenamedBags()));
        } else {
            output.put("renamedLists", new JSONObject(Collections.emptyMap()));
        }
        this.addResultItem(output, false);
    }

    private Profile getUser(String username, String password) {
        ProfileManager pm = this.im.getProfileManager();
        if (pm.hasProfile(username)) {
            if (!pm.validPassword(username, password)) {
                throw new ProfileManager.AuthenticationException("Invalid password supplied");
            }
            Profile p = pm.getProfile(username, (Map)this.im.getClassKeys());
            return p;
        }
        throw new ProfileManager.AuthenticationException("Unknown username: " + username);
    }
}

