/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.HashMap;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.core.ISO8601DateFormat;
import org.intermine.webservice.server.core.ReadWriteJSONService;
import org.intermine.webservice.server.user.DeletionToken;
import org.intermine.webservice.server.user.DeletionTokens;

public class NewDeletionTokenService
extends ReadWriteJSONService {
    protected final DeletionTokens tokenFactory = DeletionTokens.getInstance();

    public NewDeletionTokenService(InterMineAPI im) {
        super(im);
    }

    protected String getResultsKey() {
        return "token";
    }

    protected void execute() throws Exception {
        int lifeSpan = this.getIntParameter("validity", Integer.valueOf(60));
        Profile profile = this.getPermission().getProfile();
        DeletionToken token = this.tokenFactory.createToken(profile, lifeSpan);
        this.serveToken(token);
    }

    protected void serveToken(DeletionToken token) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("uuid", token.getUUID().toString());
        info.put("expiry", ISO8601DateFormat.getFormatter().format(token.getExpiry()));
        info.put("secondsRemaining", (token.getExpiry().getTime() - System.currentTimeMillis()) / 1000L);
        this.addResultItem(info, false);
    }
}

