/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.util.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.util.NameUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.core.RateLimitHistory;
import org.intermine.webservice.server.exceptions.RateLimitException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.user.NewUserService;
import org.json.JSONObject;

public class NewUserService
extends JSONService {
    private static final String DEFAULTING_TO_1000PH = "Configured new user rate limit is not a valid integer. Defaulting to 1000 per hour";
    private static final Logger LOG = Logger.getLogger(NewUserService.class);
    private int maxNewUsersPerAddressPerHour = 1000;
    private static RateLimitHistory requestHistory = null;

    public NewUserService(InterMineAPI im) {
        super(im);
        if (requestHistory == null) {
            Properties webProperties = InterMineContext.getWebProperties();
            String rateLimit = webProperties.getProperty("webservice.newuser.ratelimit");
            if (rateLimit != null) {
                try {
                    this.maxNewUsersPerAddressPerHour = Integer.valueOf(rateLimit.trim());
                }
                catch (NumberFormatException e) {
                    LOG.error(DEFAULTING_TO_1000PH, (Throwable)e);
                    this.maxNewUsersPerAddressPerHour = 1000;
                }
            }
            requestHistory = new RateLimitHistory(3600, this.maxNewUsersPerAddressPerHour);
        }
    }

    protected void validateState() {
        super.validateState();
        String ipAddr = this.request.getRemoteAddr();
        if (!requestHistory.isWithinLimit(ipAddr)) {
            throw new RateLimitException(ipAddr, this.maxNewUsersPerAddressPerHour);
        }
        requestHistory.recordRequest(ipAddr);
    }

    protected void execute() throws Exception {
        NewUserInput input = new NewUserInput(this);
        Profile currentProfile = this.getPermission().getProfile();
        ProfileManager pm = this.im.getProfileManager();
        pm.createNewProfile(input.getUsername(), input.getPassword());
        Profile newProfile = pm.getProfile(input.getUsername());
        if (newProfile == null) {
            throw new ServiceException("Creating a new profile failed");
        }
        ProfileMergeIssues issues = null;
        if (currentProfile != null) {
            issues = this.attachAnonSavedBags(currentProfile, newProfile);
        }
        JSONObject user = new JSONObject();
        user.put("username", (Object)input.getUsername());
        user.put("renamedLists", (Object)new JSONObject(issues.getRenamedBags()));
        WelcomeAction welcomeMessage = new WelcomeAction(input.getUsername());
        if (!InterMineContext.queueMessage((MailAction)welcomeMessage)) {
            LOG.error("Mail queue capacity exceeded. Not sending welcome message");
        }
        String mailingList = null;
        if (input.subscribeToList()) {
            mailingList = this.getProperty("mail.mailing-list");
            SubscribeAction subscribe = new SubscribeAction(input.getUsername());
            if (!InterMineContext.queueMessage((MailAction)subscribe)) {
                LOG.error("Mail queue capacity exceeded. Not sending subscription message");
            }
        }
        user.put("subscribedToList", mailingList != null);
        user.put("mailingList", (Object)mailingList);
        user.put("temporaryToken", (Object)pm.generate24hrKey(newProfile));
        this.output.addResultItem(Arrays.asList(user.toString()));
    }

    protected Map<String, Object> getHeaderAttributes() {
        Map retval = super.getHeaderAttributes();
        retval.put("intro", "\"user\":");
        return retval;
    }

    private ProfileMergeIssues attachAnonSavedBags(Profile fromProfile, Profile newProfile) {
        Map mergeBags = Collections.emptyMap();
        ProfileMergeIssues issues = new ProfileMergeIssues();
        if (fromProfile != null) {
            mergeBags = fromProfile.getSavedBags();
        }
        for (Map.Entry entry : mergeBags.entrySet()) {
            InterMineBag bag = (InterMineBag)entry.getValue();
            try {
                bag.setProfileId(newProfile.getUserId());
                String name = NameUtil.validateName(newProfile.getSavedBags().keySet(), (String)((String)entry.getKey()));
                if (!((String)entry.getKey()).equals(name)) {
                    issues.addRenamedBag((String)entry.getKey(), name);
                }
                bag.setName(name);
                newProfile.saveBag(name, bag);
            }
            catch (ObjectStoreException iex) {
                throw new RuntimeException(iex.getMessage());
            }
        }
        return issues;
    }

    static /* synthetic */ HttpServletRequest access$000(NewUserService x0) {
        return x0.request;
    }

    static /* synthetic */ HttpServletRequest access$100(NewUserService x0) {
        return x0.request;
    }

    static /* synthetic */ HttpServletRequest access$200(NewUserService x0) {
        return x0.request;
    }

    static /* synthetic */ InterMineAPI access$300(NewUserService x0) {
        return x0.im;
    }
}

