/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.TableWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.widget.WidgetProcessor;
import org.intermine.webservice.server.widget.WidgetProcessorImpl;

public abstract class WidgetProcessorImpl
implements WidgetProcessor {
    public abstract List<String> process(String var1, WidgetConfig var2);

    protected WidgetType getWidgetType(WidgetConfig widgetConfig) {
        WidgetType ret = WidgetType.UNKNOWN;
        if (widgetConfig instanceof EnrichmentWidgetConfig) {
            ret = WidgetType.ENRICHMENT;
        } else if (widgetConfig instanceof GraphWidgetConfig) {
            ret = WidgetType.CHART;
        } else if (widgetConfig instanceof TableWidgetConfig) {
            ret = WidgetType.TABLE;
        }
        return ret;
    }

    protected Map<String, String> getLabels(GraphWidgetConfig widgetConfig) {
        String rangeAxis;
        String domainAxis;
        HashMap<String, String> labels = new HashMap<String, String>();
        if ("StackedBarChart".equals(widgetConfig.getGraphType())) {
            domainAxis = "y";
            rangeAxis = "x";
        } else {
            domainAxis = "x";
            rangeAxis = "y";
        }
        labels.put(domainAxis, widgetConfig.getDomainLabel());
        labels.put(rangeAxis, widgetConfig.getRangeLabel());
        return labels;
    }
}

